package com.digiwin.dap.nest.infrastructure.spring.boot.core.config;

import com.digiwin.dap.nest.kernel.core.config.DwCenterPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.DwEnvPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwPostPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwPrePropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwPropertyListener;
import com.digiwin.dap.nest.kernel.core.config.DwSpringProperty;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.infrastructure.spring.boot.util.DwSpringBootUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringCloudFix;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * org.springframework.boot.context.event.EventPublishingRunListener
 * org.springframework.boot.context.event.EventPublishingRunListener#environmentPrepared(org.springframework.core.env.ConfigurableEnvironment)
 * org.springframework.boot.context.config.ConfigFileApplicationListener#onApplicationEvent(org.springframework.context.ApplicationEvent)
 */
public class DwEnvironmentPostProcessor implements EnvironmentPostProcessor, Ordered {
    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!DwSpringCloudFix.isCloudContainer()) {
            DwSpringBootUtil.setEnvironment(environment);
            DwSpringProperty.setEnvironmentHandler(environment::getProperty);
            // 预加载一次配置, 本地&env
            DwSpringPropertyProcessor.loadLocalConfig(environment);
            DwPropertyHandler.Processor.loadJaPropertyHandler(DwEnvPropertyHandler.class);
            // 预配置, 通常是跟着代码走,
            DwPropertyHandler.Processor.loadJaPropertyHandler(DwPrePropertyHandler.class);
            // 配置中心
            if (DwEnvProperty.useCenter() && !DwEnvProperty.priorityCenter()) {
                DwPropertyHandler.Processor.loadJaPropertyHandler(DwCenterPropertyHandler.class);
            }
            // 用来适配本地是否覆盖云上
            DwSpringPropertyProcessor.loadLocalConfig(environment);
            // 配置中心
            if (DwEnvProperty.useCenter() && DwEnvProperty.priorityCenter()) {
                DwPropertyHandler.Processor.loadJaPropertyHandler(DwCenterPropertyHandler.class);
            }
            // 后置配置
            DwPropertyHandler.Processor.loadJaPropertyHandler(DwPostPropertyHandler.class);

            String env = DwEnvProperty.getEnv();
            if (DwStringUtil.isNotEmpty(env)) {
                environment.setActiveProfiles(env);
            }
            DwSpringPropertyProcessor.setEnvironment(environment, "jaProperties");

            DwPropertyListener.executeCommonListener();
            DwPropertyListener.executeBizListener();

            DwSpringPropertyProcessor.outputFinalConfig(environment);
        }

    }

    @Override
    public int getOrder() {
        return 0;
    }
}