package com.digiwin.dap.nest.infrastructure.spring.boot.core.context;

import com.digiwin.dap.nest.kernel.core.context.DwMapContextLink;
import com.digiwin.dap.nest.kernel.core.context.biz.DwCoreContextEntity;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.infrastructure.spring.boot.util.DwSpringI18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.Locale;
import java.util.Map;

public class DwAcceptLanguageContextLink implements DwMapContextLink<DwCoreContextEntity> {

    @Override
    public void inherit(Map<String, String> source, DwCoreContextEntity context) {
        if (null == DwSpringI18nUtil.LocaleThreadLocal.get()) {
            String acceptLanguage = source.get(DwSpringI18nUtil.Header);
            if (DwStringUtil.isEmpty(acceptLanguage)) {
                acceptLanguage = source.get(DwSpringI18nUtil.HeaderUp);
            }

            if (DwStringUtil.isNotEmpty(acceptLanguage)) {
                Locale locale = DwSpringI18nUtil.parseLocales(acceptLanguage);
                DwSpringI18nUtil.LocaleThreadLocal.set(locale);
                LocaleContextHolder.setLocale(locale);
            }
        }

    }

    @Override
    public void transmit(DwCoreContextEntity source, Map<String, String> target) {
        Locale locale = DwSpringI18nUtil.LocaleThreadLocal.get();
        if (null != locale) {
            // zh-CN
            transmit(target, DwSpringI18nUtil.Header, locale.toLanguageTag());
        }

    }

    @Override
    public void remove() {
        DwSpringI18nUtil.LocaleThreadLocal.remove();
        LocaleContextHolder.resetLocaleContext();
    }
}
