package com.digiwin.dap.nest.infrastructure.spring.boot.dapper.node;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.dapper.meta.DapperAnnotation;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAopUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass({Scheduled.class})
public class DwNodeSpanScheduled implements JaNodeSpanResolver, JaDapperAspectPointcut {

    private static final NodeKind schedulerNodeKind = new NodeKind("scheduler", true)
            .buildDapperAnnotation(DapperAnnotation.InstanceSkip)
            .buildChainInitialHandler((objects, rspSpan, invocation) -> DwMDC.remove())
            .buildChainFinalHandler((objects, rspSpan, invocation) -> DwMDC.put(DwMDC.createTraceId()));

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        if (null != JaAopUtil.getMethodAnnotation(invocation, Scheduled.class)) {
            return get(schedulerNodeKind);
        }
        return null;
    }

    @Override
    public String getExpression() {
        String expression = DwConfig.get("dapper.aspect.pointcut.scheduler");
        if (DwStringUtil.isNotEmpty(expression)) {
            return expression;
        }
        return "@annotation(org.springframework.scheduling.annotation.Scheduled)";
    }
}
