package com.digiwin.dap.nest.infrastructure.spring.boot.util;

import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.DwStringUtil;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DwSpringExecptionUtil {
    private DwSpringExecptionUtil() {
    }

    public static String executeMethodArgumentNotValidException(String apiName, MethodArgumentNotValidException e) {
        List<ObjectError> allErrors = e.getBindingResult().getAllErrors();
        Set<String> set = new HashSet<>();
        allErrors.forEach(objectError -> {
            String defaultMessage = objectError.getDefaultMessage();
            if (DwStringUtil.isNotEmpty(defaultMessage)) {
                if (defaultMessage.startsWith("{")) {
                    defaultMessage = defaultMessage.substring(1, defaultMessage.length() - 1);
                }
                set.add(defaultMessage);
            }
        });
        // 返回给前端
        StringBuilder message = new StringBuilder();
        // 输出日志
        StringBuilder errorLog = new StringBuilder();

        boolean isFirst = true;
        for (String error : set) {
            if (isFirst) {
                isFirst = false;
            } else {
                message.append(",");
                errorLog.append(",");
            }
            message.append(DwSpringI18nUtil.getMessage(error));
            errorLog.append(DwSpringI18nUtil.getMessage(error, Locale.CHINA));
        }
        DwLog.error("[{}]校验异常:{}", apiName, errorLog.toString());
        return message.toString();
    }
}
