/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.core.config;

import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringBeanUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringContextUtil;
import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.DwEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.DwProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.kernel.meta.function.JaFunctionP;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class DwSpringPropertyProcessor {
    private static final Properties jaProperties = new Properties();
    private static final String LoadPropertySourcePre = "application";

    private DwSpringPropertyProcessor() {
    }

    public static synchronized void setEnvironment(ConfigurableEnvironment environment, String name) {
        MutablePropertySources propertySources = DwSpringPropertyProcessor.getMutablePropertySources(environment);
        if (null != propertySources) {
            String relativePropertySourceName = null;
            for (PropertySource propertySource : propertySources) {
                if (null == propertySource || !propertySource.getName().contains(LoadPropertySourcePre)) continue;
                relativePropertySourceName = propertySource.getName();
                break;
            }
            DwProperty.getPropertyMap().forEach(jaProperties::put);
            if (null == relativePropertySourceName) {
                propertySources.addLast((PropertySource)new PropertiesPropertySource(name, jaProperties));
            } else {
                propertySources.addBefore(relativePropertySourceName, (PropertySource)new PropertiesPropertySource(name, jaProperties));
            }
        }
    }

    public static void outputFinalConfig(ConfigurableEnvironment environment) {
        if (DwEnvProperty.isCD() || Boolean.TRUE.equals(DwConfig.getBoolean((String)"config.output", (Boolean)false))) {
            try (FileOutputStream outputStream = new FileOutputStream("nest.properties");){
                TreeMap map = new TreeMap();
                MutablePropertySources propertySources = DwSpringPropertyProcessor.getMutablePropertySources(environment);
                if (null != propertySources) {
                    ArrayList allPropertySourcesList = new ArrayList();
                    propertySources.forEach(propertySource -> DwSpringPropertyProcessor.invokeMapPropertySource(propertySource, (JaFunctionP<Map<String, Object>>)((JaFunctionP)allPropertySourcesList::add)));
                    if (JaCollectionUtil.isNotEmpty(allPropertySourcesList)) {
                        for (int i = allPropertySourcesList.size() - 1; i >= 0; --i) {
                            ((Map)allPropertySourcesList.get(i)).forEach((s, o) -> map.put(s, o.toString()));
                        }
                    }
                }
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)map);
                properties.store(outputStream, null);
            }
            catch (Throwable e) {
                DwLog.warn((String)"final.properties store error:{}", (Object[])new Object[]{e});
            }
        }
    }

    public static <T> T refresh(Class<T> configBeanClass) {
        try {
            DwProperty.getPropertyMap().forEach(jaProperties::put);
            Object targetConfigBean = DwSpringBeanUtil.getBean(configBeanClass);
            ConfigurationPropertiesBindingPostProcessor bindingPostProcessor = (ConfigurationPropertiesBindingPostProcessor)DwSpringBeanUtil.getBean(ConfigurationPropertiesBindingPostProcessor.class);
            assert (bindingPostProcessor != null);
            assert (targetConfigBean != null);
            String beanName = DwSpringContextUtil.getApplicationContext().getBeanNamesForType(configBeanClass)[0];
            bindingPostProcessor.postProcessBeforeInitialization(targetConfigBean, beanName);
            return (T)targetConfigBean;
        }
        catch (Throwable e) {
            DwLog.error((String)"{} config refresh error:{}", (Object[])new Object[]{configBeanClass.getName(), e.getMessage()});
            return null;
        }
    }

    public static synchronized void loadLocalConfig(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = DwSpringPropertyProcessor.getMutablePropertySources(environment);
        if (null != propertySources) {
            ArrayList applicationConfigPropertySourcesList = new ArrayList();
            propertySources.forEach(propertySource -> {
                if (null != propertySource && propertySource.getName().contains(LoadPropertySourcePre)) {
                    DwSpringPropertyProcessor.invokeMapPropertySource(propertySource, (JaFunctionP<Map<String, Object>>)((JaFunctionP)applicationConfigPropertySourcesList::add));
                }
            });
            if (JaCollectionUtil.isNotEmpty(applicationConfigPropertySourcesList)) {
                for (int i = applicationConfigPropertySourcesList.size() - 1; i >= 0; --i) {
                    ((Map)applicationConfigPropertySourcesList.get(i)).forEach((s, o) -> DwProperty.put((String)s, (Object)o.toString()));
                }
            }
        }
    }

    public static MutablePropertySources getMutablePropertySources(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = null;
        if (environment instanceof AbstractEnvironment) {
            propertySources = environment.getPropertySources();
        } else {
            DwLog.get().warn("not support this environment{}", (Object)environment.getClass().getName());
        }
        return propertySources;
    }

    public static void invokeMapPropertySource(PropertySource<?> propertySource, JaFunctionP<Map<String, Object>> functionP) {
        Object source = propertySource.getSource();
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            if (JaCollectionUtil.isNotEmpty((Map)sourceMap)) {
                functionP.apply((Object)sourceMap);
            }
        } else {
            DwLog.info((String)"unknown propertySource, name:{}", (Object[])new Object[]{propertySource.getName()});
        }
    }
}

