/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.boot.dapper.node;

import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringAopUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringBeanUtil;
import com.digiwin.dap.nest.kernel.core.context.DwMapContextChain;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
public class DwNodeSpanRestTemplate
implements JaNodeSpanResolver,
JaDapperAspectPointcut,
ClientHttpRequestInterceptor {
    public static final String ProxyClassName = "org.springframework.web.client.RestTemplate";

    private static void initNodeKind() {
        NodeKind.Constant.RestTemplate.buildRspHandler(o -> o instanceof ResponseEntity ? ((ResponseEntity)o).getBody() : o).buildNodeIdHandler(invocation -> {
            Object[] arguments = invocation.getArguments();
            if (JaCollectionUtil.isNotEmpty((Object[])arguments)) {
                Object argument = arguments[0];
                if (argument instanceof String || argument instanceof URI) {
                    return argument.toString();
                }
                if (argument instanceof RequestEntity) {
                    return ((RequestEntity)argument).getUrl().toString();
                }
            }
            return "" + invocation.getMethod().hashCode();
        }).buildReqArgsHandler(args -> {
            if (JaCollectionUtil.isEmpty((Object[])args)) {
                return args;
            }
            ArrayList<Object> objects = new ArrayList<Object>(((Object[])args).length);
            for (Object arg : args) {
                if (arg instanceof String || arg instanceof URI || arg instanceof HttpMethod || arg instanceof Type || arg instanceof ParameterizedTypeReference) continue;
                if (arg instanceof HttpEntity) {
                    objects.add(((HttpEntity)arg).getBody());
                    continue;
                }
                objects.add(arg);
            }
            return objects.toArray();
        }).buildSpanIdThreadLocal();
    }

    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        Object proxy;
        if (invocation instanceof ReflectiveMethodInvocation && (proxy = ((ReflectiveMethodInvocation)invocation).getProxy()).toString().startsWith(ProxyClassName)) {
            return this.get(NodeKind.Constant.RestTemplate);
        }
        return null;
    }

    public String getExpression() {
        return "execution(* org.springframework.web.client.RestOperations.*(..))";
    }

    @NonNull
    public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders headers = request.getHeaders();
        DwMapContextChain.getInstance().transmit().forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        headers.add(DwMDC.KeyParentSpanId, NodeKind.Constant.RestTemplate.transmitSpanId());
        return execution.execute(request, body);
    }

    public void initNodeSpanResolver() {
        List beanList = DwSpringBeanUtil.getBeanList(RestTemplate.class);
        if (JaCollectionUtil.isNotEmpty((Collection)beanList)) {
            beanList.forEach(restTemplate -> ((RestTemplate)DwSpringAopUtil.getSingletonTarget((Object)restTemplate)).getInterceptors().add(0, this));
        } else {
            DwLog.warn((String)"JaNodeSpanRestTemplate add interceptor error : restTemplate is null", (Object[])new Object[0]);
        }
    }

    static {
        DwNodeSpanRestTemplate.initNodeKind();
    }
}

