package com.digiwin.dap.nest.infrastructure.spring.boot.core;

import com.digiwin.dap.nest.infrastructure.spring.boot.util.DwSpringBootUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringCloudFix;
import com.digiwin.dap.nest.kernel.core.util.DwSpiUtil;
import com.digiwin.dap.nest.kernel.core.util.DwStartupHook;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

import java.time.Duration;
import java.util.Objects;

/**
 * 注意高低版本spring-boot兼容
 *
 * @author chenjian
 * @since 2024年04月21日 18:59:42
 */
public class DwSpringApplicationRunListener implements SpringApplicationRunListener, Ordered {

    public DwSpringApplicationRunListener(SpringApplication springApplication, String[] args) {
        if (!DwSpringCloudFix.isCloudContainer()) {
            DwSpringBootUtil.setSpringApplication(springApplication);
            DwSpringBootUtil.setArgs(args);
            DwSpiUtil.getCustomBasePackageSet().addAll(Objects.requireNonNull(DwSpringBootUtil.initRootPackageSet()));
            DwStartupHook.start();
        }
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void started(ConfigurableApplicationContext context, Duration timeTaken) {
        DwStartupHook.notify(null);
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        DwStartupHook.notify(exception);
    }

    @Override
    public int getOrder() {
        return -10;
    }

}