package com.jugg.agile.openfeign;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.servicemesh.JaServiceDependencyRegistry;
import com.jugg.agile.middleware.nacos.discovery.JaNamingService;

public class JaFeignDependencyHandler {
    static {
        JaPropertyListener.addAndRunCommonListener(() -> {
            boolean enabled = JaProperty.getBoolean("ja.feign.dapper.enableServiceMesh", false);
            String key = "feign-dependency-handler";
            if (enabled) {
                JaServiceDependencyRegistry.registerHandler(key, JaFeignDependencyHandler::subscribeTarget);
            } else {
                JaServiceDependencyRegistry.removeHandler(key);
            }
        });
    }

    public static void subscribeTarget(String targetService) {
        try {
            JaNamingService.getNamingService().subscribe(targetService, event -> {
            });
        } catch (Throwable e) {
            JaLog.warn("JaFeignDependencyHandler.subscribeTarget error:{}", e.getMessage());
        }
    }
}
