package com.jugg.agile.openfeign;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class JaFeignProcessor {
    private JaFeignProcessor() {
    }

    public static boolean hasLocalImpl(BeanDefinitionRegistry registry, String className) {
        Boolean registerLocal = JaProperty.getBoolean("ja.feign.registerLocal");
        if (null != registerLocal) {
            return !registerLocal;
        }
        try {
            if (registry.containsBeanDefinition(className)) {
                return true;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String[] beanNamesForType = ((DefaultListableBeanFactory) registry).getBeanNamesForType(classLoader.loadClass(className));
            if (JaCollectionUtil.isNotEmpty(beanNamesForType)) {
                return true;
            }


        } catch (Throwable e) {
            // no things
        }
        return false;
    }

}
