/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.openfeign;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.servicemesh.JaServiceDependencyRegistry;
import com.jugg.agile.middleware.nacos.discovery.JaNamingService;

public class JaFeignDependencyHandler {
    public static void subscribeTarget(String targetService) {
        try {
            JaNamingService.getNamingService().subscribe(targetService, event -> {});
        }
        catch (Throwable e) {
            JaLog.warn((String)"JaFeignDependencyHandler.subscribeTarget error:{}", (Object[])new Object[]{e.getMessage()});
        }
    }

    static {
        JaPropertyListener.addAndRunCommonListener(() -> {
            boolean enabled = JaProperty.getBoolean((String)"ja.feign.dapper.enableServiceMesh", (Boolean)false);
            String key = "feign-dependency-handler";
            if (enabled) {
                JaServiceDependencyRegistry.registerHandler((String)key, JaFeignDependencyHandler::subscribeTarget);
            } else {
                JaServiceDependencyRegistry.removeHandler((String)key);
            }
        });
    }
}

