/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.openfeign;

import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.dapper.servicemesh.JaServiceDependencyRegistry;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;

@Component
public class JaNodeSpanFeign
implements JaNodeSpanResolver,
JaDapperAspectPointcut,
RequestInterceptor {
    private static final NodeKind feignNodeKind = new NodeKind("rpc").buildSpanIdThreadLocal();

    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        FeignClient feignClient = (FeignClient)JaAopUtil.getClassAnnotation((MethodInvocation)invocation, FeignClient.class);
        if (null != feignClient) {
            JaServiceDependencyRegistry.reportDependency((String)feignClient.name());
            return this.get(feignNodeKind);
        }
        return null;
    }

    public String getExpression() {
        return "@within(org.springframework.cloud.openfeign.FeignClient)";
    }

    public void apply(RequestTemplate template) {
        JaMapContextChain.getInstance().transmit().forEach((x$0, xva$1) -> template.header(x$0, new String[]{xva$1}));
        template.header(JaMDC.KeyParentSpanId, new String[]{feignNodeKind.transmitSpanId()});
    }
}

