/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.cloud.openfeign;

import com.digiwin.dap.nest.kernel.core.context.DwMapContextChain;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.dapper.servicemesh.JaServiceDependencyRegistry;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAopUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;

@Component
public class JaNodeSpanFeign
implements JaNodeSpanResolver,
JaDapperAspectPointcut,
RequestInterceptor {
    private static final NodeKind feignNodeKind = new NodeKind("rpc").buildSpanIdThreadLocal();

    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        FeignClient feignClient = (FeignClient)JaAopUtil.getClassAnnotation((MethodInvocation)invocation, FeignClient.class);
        if (null != feignClient) {
            JaServiceDependencyRegistry.reportDependency((String)feignClient.name());
            return this.get(feignNodeKind);
        }
        return null;
    }

    public String getExpression() {
        return "@within(org.springframework.cloud.openfeign.FeignClient)";
    }

    public void apply(RequestTemplate template) {
        DwMapContextChain.getInstance().transmit().forEach((x$0, xva$1) -> template.header(x$0, new String[]{xva$1}));
        template.header(DwMDC.KeyParentSpanId, new String[]{feignNodeKind.transmitSpanId()});
    }
}

