package com.digiwin.dap.nest.infrastructure.spring.cloud.openfeign;

import com.digiwin.dap.nest.kernel.core.context.DwMapContextChain;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaDapperAspectPointcut;
import com.digiwin.dap.nest.kernel.core.dapper.aspect.JaNodeSpanResolver;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwMDC;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeKind;
import com.digiwin.dap.nest.kernel.core.dapper.meta.NodeSpan;
import com.digiwin.dap.nest.kernel.core.dapper.servicemesh.JaServiceDependencyRegistry;
import com.digiwin.dap.nest.kernel.core.util.bytecode.aop.JaAopUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;

@Component
public class JaNodeSpanFeign implements JaNodeSpanResolver, JaDapperAspectPointcut, RequestInterceptor {

    private static final NodeKind feignNodeKind = new NodeKind("rpc")
//            .buildReqArgsHandler(args -> {
//                if (JaCollectionUtil.isEmpty(args)) {
//                    return args;
//                }
//                ArrayList<Object> objects = new ArrayList<>(args.length);
//                for (Object arg : args) {
//                    if (arg instanceof MultipartRequest
//                            || arg instanceof InputStreamSource
//                    ) {
//                        continue;
//                    }
//                    objects.add(arg);
//                }
//                return objects.toArray();
//            })
            .buildSpanIdThreadLocal();

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        FeignClient feignClient = JaAopUtil.getClassAnnotation(invocation, FeignClient.class);
        if (null != feignClient) {
            JaServiceDependencyRegistry.reportDependency(feignClient.name());
            return get(feignNodeKind);
        }
        return null;
    }

    @Override
    public String getExpression() {
        return "@within(org.springframework.cloud.openfeign.FeignClient)";
    }

    @Override
    public void apply(RequestTemplate template) {
        DwMapContextChain.getInstance().transmit().forEach(template::header);
        template.header(DwMDC.KeyParentSpanId, JaNodeSpanFeign.feignNodeKind.transmitSpanId());
    }
}
