/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.cloud.openfeign;

import com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery.DwNamingService;
import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.DwPropertyListener;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.dapper.servicemesh.JaServiceDependencyRegistry;

public class JaFeignDependencyHandler {
    public static void subscribeTarget(String targetService) {
        try {
            DwNamingService.getNamingService().subscribe(targetService, event -> {});
        }
        catch (Throwable e) {
            DwLog.warn((String)"JaFeignDependencyHandler.subscribeTarget error:{}", (Object[])new Object[]{e.getMessage()});
        }
    }

    static {
        DwPropertyListener.addAndRunCommonListener(() -> {
            boolean enabled = DwConfig.getBoolean((String)"feign.dapper.enableServiceMesh", (Boolean)false);
            String key = "feign-dependency-handler";
            if (enabled) {
                JaServiceDependencyRegistry.registerHandler((String)key, JaFeignDependencyHandler::subscribeTarget);
            } else {
                JaServiceDependencyRegistry.removeHandler((String)key);
            }
        });
    }
}

