/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.cloud.openfeign;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.io.serialize.json.adapter.jackson.JaJacksonProcessor;
import com.digiwin.dap.nest.kernel.meta.dto.DwResultDTO;
import com.digiwin.dap.nest.kernel.meta.exception.DwException;
import com.digiwin.dap.nest.kernel.meta.handler.JaResultParseHandler;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StreamUtils;

@Configuration
public class JaFeignConfiguration {
    private static final ObjectMapper objectMapper = JaJacksonProcessor.createObjectMapper();

    @Bean
    public Decoder feignDecoder() {
        if (Boolean.TRUE.equals(DwConfig.getBoolean((String)"feign.unwrapDecoder", (Boolean)false))) {
            return new JaResultUnwrapDecoder();
        }
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(this.createHttpMessageConvertersObjectFactory()));
    }

    @Bean
    public Encoder feignEncoder() {
        return new SpringEncoder(this.createHttpMessageConvertersObjectFactory());
    }

    private ObjectFactory<HttpMessageConverters> createHttpMessageConvertersObjectFactory() {
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(objectMapper);
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{jacksonConverter});
        return () -> httpMessageConverters;
    }

    public static class JaResultUnwrapDecoder
    implements Decoder {
        public Object decode(Response response, Type type) throws IOException, FeignException {
            JaResultParseHandler result;
            if (response.body() == null) {
                return null;
            }
            JavaType wrappedType = objectMapper.getTypeFactory().constructParametricType(DwResultDTO.class, new JavaType[]{objectMapper.constructType(type)});
            try {
                result = (JaResultParseHandler)objectMapper.readValue(response.body().asInputStream(), wrappedType);
            }
            catch (Throwable e) {
                String body = StreamUtils.copyToString((InputStream)response.body().asInputStream(), (Charset)StandardCharsets.UTF_8);
                DwLog.error((String)"[{}] feign decode error[{}:{}]", (Object[])new Object[]{response.status(), body.getBytes(StandardCharsets.UTF_8)});
                throw new DwException("" + response.status(), new Object[0]).buildCodeMsg(response.reason());
            }
            if (result == null) {
                return null;
            }
            if (Boolean.FALSE.equals(result.success())) {
                throw new DwException(result.code(), new Object[0]).buildCodeMsg(result.message());
            }
            return result.data();
        }
    }
}

