package com.digiwin.dap.nest.infrastructure.spring.cloud.openfeign;

import com.digiwin.dap.nest.kernel.core.config.DwConfig;
import com.digiwin.dap.nest.kernel.core.config.DwPropertyListener;
import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.dapper.servicemesh.DwServiceDependencyRegistry;
import com.digiwin.dap.nest.infrastructure.middleware.nacos.discovery.DwNamingService;

public class JaFeignDependencyHandler {
    static {
        DwPropertyListener.addAndRunCommonListener(() -> {
            boolean enabled = DwConfig.getBoolean("feign.dapper.enableServiceMesh", false);
            String key = "feign-dependency-handler";
            if (enabled) {
                DwServiceDependencyRegistry.registerHandler(key, JaFeignDependencyHandler::subscribeTarget);
            } else {
                DwServiceDependencyRegistry.removeHandler(key);
            }
        });
    }

    public static void subscribeTarget(String targetService) {
        try {
            DwNamingService.getNamingService().subscribe(targetService, event -> {
            });
        } catch (Throwable e) {
            DwLog.warn("JaFeignDependencyHandler.subscribeTarget error:{}", e.getMessage());
        }
    }
}
