package com.jugg.agile.spring.util;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * get bean util
 *
 * @author chenjian
 * @since 2024年01月10日 10:44:04
 */
public class JaSpringBeanUtil {

    private JaSpringBeanUtil() {
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return JaSpringContextUtil.getApplicationContext().getBean(clazz);
        } catch (Throwable e) {
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    public static <T> T getBean(String name) {
        try {
            return (T) JaSpringContextUtil.getApplicationContext().getBean(name);
        } catch (Throwable e) {
            return null;
        }
    }

    public static <T> Map<String, T> getBeanMap(Class<T> clazz) {
        try {
            return JaSpringContextUtil.getApplicationContext().getBeansOfType(clazz);
        } catch (Throwable e) {
            return null;
        }
    }

    public static <T> List<T> getBeanList(Class<T> clazz) {
        Map<String, T> map = getBeanMap(clazz);
        return JaCollectionUtil.isEmpty(map) ? null : new ArrayList<>(map.values());
    }

    /***
     * 类似于getBean(String name)只是在参数中提供了需要返回到的类型。
     */
    public static <T> T getBean(String name, Class<T> requiredType) {
        try {
            return JaSpringContextUtil.getApplicationContext().getBean(name, requiredType);
        } catch (Throwable e) {
            return null;
        }
    }
}
