package com.digiwin.dap.nest.infrastructure.spring.util;

import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ProxyFactory;

public class DwSpringAopUtil {

    private DwSpringAopUtil() {
    }

    public static Object getProxy(Object obj, MethodInterceptor interceptor) {
        ProxyFactory proxy = new ProxyFactory(obj);
        proxy.setProxyTargetClass(true);
        proxy.addAdvice(interceptor);
        return proxy.getProxy();
    }

    @SuppressWarnings("unchecked")
    public static <T> T getSingletonTarget(T t) {
        Object singletonTarget = AopProxyUtils.getSingletonTarget(t);
        return null == singletonTarget ? t : (T) singletonTarget;
    }
}
