package com.digiwin.dap.nest.infrastructure.spring.util;

import com.digiwin.dap.nest.kernel.core.context.DwContext;
import com.digiwin.dap.nest.kernel.core.util.JaSpiUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.JaCollectionUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Component
public class DwSpringContextUtil implements ApplicationContextAware {

    private static Environment environment;
    private static ApplicationContext applicationContext;
    private static ConfigurableListableBeanFactory beanFactory;
    private static Class<?> mainApplicationClass;

    public static Class<?> getMainApplicationClass() {
        return mainApplicationClass;
    }

    public static void setMainApplicationClass(Class<?> mainApplicationClass) {
        DwSpringContextUtil.mainApplicationClass = mainApplicationClass;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static ConfigurableListableBeanFactory getBeanFactory() {
        return beanFactory;
    }

    @Override
    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        DwSpringContextUtil.applicationContext = applicationContext;
        DwSpringContextUtil.environment = applicationContext.getEnvironment();
        DwSpringContextUtil.beanFactory = ((ConfigurableApplicationContext) applicationContext).getBeanFactory();

        // TODO 未识别所有ComponentScan属性
        Map<String, Object> componentScans = applicationContext.getBeansWithAnnotation(ComponentScan.class);
        for (Object bean : componentScans.values()) {
            ComponentScan annotation = DwSpringAopUtil.getSingletonTarget(bean).getClass().getAnnotation(ComponentScan.class);
            if (null == annotation) {
                annotation = AnnotatedElementUtils.findMergedAnnotation(DwSpringAopUtil.getSingletonTarget(bean).getClass(), ComponentScan.class);
            }
            if (null == annotation) {
                continue;
            }

            String[] strings = annotation.basePackages();
            if (JaCollectionUtil.isNotEmpty(strings)) {
                JaSpiUtil.getCustomBasePackageSet().addAll(Arrays.asList(strings));
            }
        }


        Set<MetadataReader> readableResource = new HashSet<>();
        JaSpiUtil.getCustomBasePackageSet().forEach(s -> readableResource.addAll(DwSpringClassUtil.getReadableResource(s)));

        String name = DwContext.class.getName();
        readableResource.forEach(metadataReader -> {
            System.out.println(metadataReader.getClassMetadata().getSuperClassName());
            if (name.equals(metadataReader.getClassMetadata().getSuperClassName())) {
                JaClassUtil.load(DwSpringClassUtil.getClassPath(metadataReader));
            }
        });
    }
}
