package com.digiwin.dap.nest.infrastructure.spring.util;

public class DwSpringCloudFix {
    /**
     * 容错 cloud的 BootstrapApplicationListener
     * <p>
     * SpringApplicationRunListener
     * ApplicationContextInitializer
     * 都会重复执行
     *
     * @see org.springframework.cloud.bootstrap.BootstrapApplicationListener
     */
    public static boolean isCloudContainer() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (stackTraceElement.getClassName().endsWith("BootstrapApplicationListener")) {
                return true; // 栈处于BootstrapApplicationListener中
            }
        }
        return false;
    }
}
