package com.digiwin.dap.nest.infrastructure.spring.util;

import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import lombok.SneakyThrows;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

import java.util.ArrayList;
import java.util.List;

public class DwSpringClassUtil {

    private DwSpringClassUtil() {

    }

    @SneakyThrows
    public static List<MetadataReader> getReadableResource(String packageName) {
        packageName = ClassUtils.convertClassNameToResourcePath(packageName);
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = pathMatchingResourcePatternResolver.getResources("classpath*:" + packageName + "/**/*.class");
        CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory();
        List<MetadataReader> metadataReaderList = new ArrayList<>();
        for (Resource resource : resources) {
            if (resource.isReadable()) {
                metadataReaderList.add(readerFactory.getMetadataReader(resource));
            } else {
                DwLog.warn("{} scan class is not readable {}", packageName, resource.getFilename());
            }
        }
        return metadataReaderList;
    }

    /**
     * @return full name : biz.context.com.digiwin.dap.nest.kernel.core.JaCoreContext
     */
    @SneakyThrows
    public static String getClassPath(MetadataReader metadataReader) {
        return metadataReader.getClassMetadata().getClassName();
    }

    @SneakyThrows
    public static Class<?> getClass(MetadataReader metadataReader) {
        return JaClassUtil.getClass(getClassPath(metadataReader));
    }
}
