package com.digiwin.dap.nest.infrastructure.spring.util;

import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * get bean util
 *
 * @author chenjian
 * @since 2024年01月10日 10:44:04
 */
public class DwSpringBeanUtil {

    private DwSpringBeanUtil() {
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return DwSpringContextUtil.getApplicationContext().getBean(clazz);
        } catch (Throwable e) {
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    public static <T> T getBean(String name) {
        try {
            return (T) DwSpringContextUtil.getApplicationContext().getBean(name);
        } catch (Throwable e) {
            return null;
        }
    }

    public static <T> Map<String, T> getBeanMap(Class<T> clazz) {
        try {
            return DwSpringContextUtil.getApplicationContext().getBeansOfType(clazz);
        } catch (Throwable e) {
            return null;
        }
    }

    public static <T> List<T> getBeanList(Class<T> clazz) {
        Map<String, T> map = getBeanMap(clazz);
        return DwCollectionUtil.isEmpty(map) ? null : new ArrayList<>(map.values());
    }

    /***
     * 类似于getBean(String name)只是在参数中提供了需要返回到的类型。
     */
    public static <T> T getBean(String name, Class<T> requiredType) {
        try {
            return DwSpringContextUtil.getApplicationContext().getBean(name, requiredType);
        } catch (Throwable e) {
            return null;
        }
    }
}
