/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.util;

import com.digiwin.dap.nest.kernel.core.dapper.log.DwLog;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class DwSpringClassUtil {
    private DwSpringClassUtil() {
    }

    public static List<MetadataReader> getReadableResource(String packageName) {
        packageName = ClassUtils.convertClassNameToResourcePath((String)packageName);
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = pathMatchingResourcePatternResolver.getResources("classpath*:" + packageName + "/**/*.class");
        CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory();
        ArrayList<MetadataReader> metadataReaderList = new ArrayList<MetadataReader>();
        for (Resource resource : resources) {
            if (resource.isReadable()) {
                metadataReaderList.add(readerFactory.getMetadataReader(resource));
                continue;
            }
            DwLog.warn((String)"{} scan class is not readable {}", (Object[])new Object[]{packageName, resource.getFilename()});
        }
        return metadataReaderList;
    }

    public static String getClassPath(MetadataReader metadataReader) {
        return metadataReader.getClassMetadata().getClassName();
    }

    public static Class<?> getClass(MetadataReader metadataReader) {
        return JaClassUtil.getClass((String)DwSpringClassUtil.getClassPath(metadataReader));
    }
}

