/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.nest.infrastructure.spring.util;

import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringAopUtil;
import com.digiwin.dap.nest.infrastructure.spring.util.DwSpringClassUtil;
import com.digiwin.dap.nest.kernel.core.context.DwContext;
import com.digiwin.dap.nest.kernel.core.util.DwSpiUtil;
import com.digiwin.dap.nest.kernel.core.util.datastructure.DwCollectionUtil;
import com.digiwin.dap.nest.kernel.core.util.reflect.clazz.JaClassUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class DwSpringContextUtil
implements ApplicationContextAware {
    private static Environment environment;
    private static ApplicationContext applicationContext;
    private static ConfigurableListableBeanFactory beanFactory;
    private static Class<?> mainApplicationClass;

    public static Class<?> getMainApplicationClass() {
        return mainApplicationClass;
    }

    public static void setMainApplicationClass(Class<?> mainApplicationClass) {
        DwSpringContextUtil.mainApplicationClass = mainApplicationClass;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static ConfigurableListableBeanFactory getBeanFactory() {
        return beanFactory;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        DwSpringContextUtil.applicationContext = applicationContext;
        environment = applicationContext.getEnvironment();
        beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        Map componentScans = applicationContext.getBeansWithAnnotation(ComponentScan.class);
        for (Object bean : componentScans.values()) {
            Object[] strings;
            ComponentScan annotation = DwSpringAopUtil.getSingletonTarget(bean).getClass().getAnnotation(ComponentScan.class);
            if (null == annotation) {
                annotation = (ComponentScan)AnnotatedElementUtils.findMergedAnnotation(DwSpringAopUtil.getSingletonTarget(bean).getClass(), ComponentScan.class);
            }
            if (null == annotation || !DwCollectionUtil.isNotEmpty((Object[])(strings = annotation.basePackages()))) continue;
            DwSpiUtil.getCustomBasePackageSet().addAll(Arrays.asList(strings));
        }
        HashSet readableResource = new HashSet();
        DwSpiUtil.getCustomBasePackageSet().forEach(s -> readableResource.addAll(DwSpringClassUtil.getReadableResource(s)));
        String name = DwContext.class.getName();
        readableResource.forEach(metadataReader -> {
            if (name.equals(metadataReader.getClassMetadata().getSuperClassName())) {
                JaClassUtil.load((String)DwSpringClassUtil.getClassPath(metadataReader));
            }
        });
    }
}

