package com.digiwin.dap.nest.kernel.meta.dto;

import com.digiwin.dap.nest.kernel.meta.handler.JaResultParseHandler;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Setter
@Getter
public class DwResultDTO<T> implements JaResultParseHandler<T>, Serializable {
    private static final long serialVersionUID = 2183843735104360524L;

    public static String OK = "0";

    public DwResultDTO() {
    }

    public DwResultDTO(T data) {
        this.code = OK;
        this.data = data;
    }

    /**
     * 返回的业务数据
     */
    protected T data;

    /**
     * 业务自定义错误码
     */
    protected String code;

    /**
     * 业务自定义错误信息
     * 若果codeMsg不为空, 则直接显示
     */
    protected String codeMsg;

    public DwResultDTO<T> buildData(T data) {
        this.data = data;
        return this;
    }

    public DwResultDTO<T> buildCode(String code) {
        this.code = code;
        return this;
    }

    public DwResultDTO<T> buildCodeMsg(String codeMsg) {
        this.codeMsg = codeMsg;
        return this;
    }

    @Override
    public Boolean success() {
        return OK.equals(code);
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String message() {
        return codeMsg;
    }

    @Override
    public T data() {
        return data;
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public static JaResultParseHandler buildSuccess(Object body) {
        if (body instanceof JaResultParseHandler) {
            return (JaResultParseHandler) body;
        }
        return new DwResultDTO(body);
    }
}
