package com.digiwin.dap.nest.kernel.meta.exception;

import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class DwBaseException extends RuntimeException {
    private static final long serialVersionUID = -222070921590767864L;
    /**
     * 是否需要告警
     */
    protected boolean alarm = false;
    /**
     * 是否打印堆栈信息
     */
    protected boolean printStack = true;
    /**
     * 异常信息, 日志打印用
     */
    protected String log;

    public DwBaseException() {
    }

    public DwBaseException(Throwable cause) {
        super(cause);
    }

    public DwBaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public DwBaseException(String message) {
        super(message);
    }

    public DwBaseException buildAlarm(boolean alarm) {
        this.alarm = alarm;
        return this;
    }

    public DwBaseException buildPrintStack(boolean printStack) {
        this.printStack = printStack;
        return this;
    }

    public DwBaseException buildLog(String log) {
        this.log = log;
        return this;
    }
}
