package com.digiwin.dap.nest.kernel.meta.exception;

import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class DwException extends DwBaseException {
    private static final long serialVersionUID = -5791612857481866355L;
    /**
     * i18n对应的code, 给用户看的
     */
    protected String code;
    /**
     * code对应的占位值
     * 例:串码:{0},订单号:{1}已锁定,请核实!
     * codeFormatArgs : awsdf1231, 011115764
     * 中文:串码:awsdf1231,订单号:011115764已锁定,请核实!
     * 英文:IMEI:awsdf1231,Order:011115764Locked, please check!
     */
    protected Object[] codeFormatArgs;
    /**
     * 当无需翻译时, 直接使用codeMsg
     */
    protected String codeMsg;


    public DwException() {
    }

    public DwException(String code, Object... codeFormatArgs) {
        this.code = code;
        this.codeFormatArgs = codeFormatArgs;
    }

    public DwException(Throwable cause) {
        super(cause);
    }

    public DwException(Throwable cause, String code, Object... codeFormatArgs) {
        super(cause);
        this.code = code;
        this.codeFormatArgs = codeFormatArgs;
    }

    @Override
    public String getMessage() {
        if (null != codeMsg && codeMsg.length() != 0) {
            return codeMsg;
        }
        if (null != log && log.length() != 0) {
            return log;
        }
        return code;
    }

    public DwException buildCode(String code) {
        this.code = code;
        return this;
    }

    public DwException buildCodeMsg(String codeMsg) {
        this.codeMsg = codeMsg;
        return this;
    }

    public DwException buildCodeFormatArgs(Object... codeFormatArgs) {
        this.codeFormatArgs = codeFormatArgs;
        return this;
    }

}
