package com.digiwin.dap.nest.kernel.meta.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum JaLanguageEnum {
    CN("zh-CN"),
    EN("en-US"),
    TH("th-TH"),
    ;

    private final String language;

    private static final Map<String, JaLanguageEnum> enumMap = new HashMap<>();

    static {
        for (JaLanguageEnum value : JaLanguageEnum.values()) {
            enumMap.put(value.getLanguage(), value);
        }
    }

    public static Map<String, JaLanguageEnum> getEnumMap() {
        return enumMap;
    }
}
