package com.digiwin.dap.nest.standard.common.config;

import com.digiwin.dap.nest.kernel.core.config.JaEnvPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.JaSystemProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.logback.JaLogback;

/**
 * logback
 *
 * @author chenjian
 * @since 2024年08月02日 09:58:31
 */
public class DwLogbackEnvPropertyHandler implements JaEnvPropertyHandler {
    @Override
    public void addAndCover() {
        // 默认的日志配置
        JaSystemProperty.putByEnv(JaLogback.KeyLocation, JaLogback.KeyLocation, "classpath:log/logback/logback-jugg-b.xml");
        JaSystemProperty.putByEnv("ja_log_path", "ja_log_path", "logs");
        JaSystemProperty.putByEnv("ja_info_maxFileSize", "ja_info_maxFileSize", "1GB");
        JaSystemProperty.putByEnv("ja_info_maxHistory", "ja_info_maxHistory", "90");
        JaSystemProperty.putByEnv("ja_info_totalSizeCap", "ja_info_totalSizeCap", "2GB");
    }

    @Override
    public int order() {
        return -9;
    }
}
