package com.digiwin.dap.nest.standard.common.config;

import com.digiwin.dap.nest.kernel.core.config.DwEnvPropertyHandler;
import com.digiwin.dap.nest.kernel.core.config.DwSystemProperty;
import com.digiwin.dap.nest.kernel.core.dapper.log.logback.DwLogback;

/**
 * logback
 *
 * @author chenjian
 * @since 2024年08月02日 09:58:31
 */
public class DwLogbackEnvPropertyHandler implements DwEnvPropertyHandler {
    @Override
    public void addAndCover() {
        // 默认的日志配置
        DwSystemProperty.putByEnv(DwLogback.KeyLocation, DwLogback.KeyLocation, "classpath:log/logback/logback-jugg-b.xml");
        DwSystemProperty.putByEnv("ja_log_path", "ja_log_path", "logs");
        DwSystemProperty.putByEnv("ja_info_maxFileSize", "ja_info_maxFileSize", "1GB");
        DwSystemProperty.putByEnv("ja_info_maxHistory", "ja_info_maxHistory", "90");
        DwSystemProperty.putByEnv("ja_info_totalSizeCap", "ja_info_totalSizeCap", "2GB");
    }

    @Override
    public int order() {
        return -9;
    }
}
