package com.digiwin.dap.nest.standard.common.config;

import com.digiwin.dap.nest.kernel.core.config.DwEnvProperty;
import com.digiwin.dap.nest.kernel.core.config.DwPostPropertyHandler;
import com.digiwin.dap.nest.kernel.core.dapper.alarm.DwAlarm;
import com.digiwin.dap.nest.kernel.core.dapper.alarm.DwNotify;
import com.digiwin.dap.nest.kernel.core.dapper.alarm.adapter.qywx.DwQyWxAlarm;

public class DwAlarmPostPropertyHandler implements DwPostPropertyHandler {
    @Override
    public void addAndCover() {
        if (DwEnvProperty.isCD()) {
            DwAlarm.setAlarmHandler(new DwQyWxAlarm("default")::alarm);
            DwAlarm.setThrowableHandler(new DwQyWxAlarm("throwable")::alarm);
            DwNotify.setNotifyHandler(new DwQyWxAlarm("notify")::alarm);
        }
    }

    @Override
    public int order() {
        return 100;
    }
}
