/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.dcc.core.GenerateSqlExecute;
import com.digiwin.dcc.core.entity.model.DataModel;
import com.digiwin.dcc.core.entity.model.ModelField;
import com.digiwin.dcc.core.entity.model.ModelTable;
import com.digiwin.dcc.core.entity.query.PlaygroundComputedField;
import com.digiwin.dcc.core.entity.query.PlaygroundDimensionField;
import com.digiwin.dcc.core.entity.query.PlaygroundFilter;
import com.digiwin.dcc.core.entity.query.PlaygroundHavingFilter;
import com.digiwin.dcc.core.entity.query.PlaygroundMeasureField;
import com.digiwin.dcc.core.entity.query.PlaygroundPage;
import com.digiwin.dcc.core.entity.query.PlaygroundParamsField;
import com.digiwin.dcc.core.entity.query.PlaygroundQuery;
import com.digiwin.dcc.core.entity.query.PlaygroundSortField;
import com.digiwin.dcc.core.entity.query.TranslateConfig;
import com.digiwin.dcc.core.entity.sqlObj.SQLFragment;
import com.digiwin.dcc.core.entity.sqlObj.SQLTranslateVo;
import com.digiwin.dcc.core.provider.ProviderFactory;
import com.digiwin.dcc.core.provider.query.SqlTranslatorProvider;
import com.digiwin.dcc.model.constant.SQLConstants;
import com.digiwin.dcc.model.dto.ApiHistoryData;
import com.digiwin.dcc.model.dto.BaseField;
import com.digiwin.dcc.model.dto.Model;
import com.digiwin.dcc.model.dto.ModelLink;
import com.digiwin.dcc.model.dto.ModelQuery;
import com.digiwin.dcc.model.dto.ModelQueryInfo;
import com.digiwin.dcc.model.dto.OrderField;
import com.digiwin.dcc.model.dto.ParamField;
import com.digiwin.dcc.model.dto.QueryComputedField;
import com.digiwin.dcc.model.dto.QueryDimension;
import com.digiwin.dcc.model.dto.QueryMeasure;
import com.digiwin.dcc.model.dto.ReturnField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class QueryUtil {
    private static final GenerateSqlExecute generateSqlExecute = GenerateSqlExecute.getInstance();

    public static SQLFragment translateSql(Model model, ModelQuery modelQuery) {
        DataModel dataModel = QueryUtil.processDataModel(model);
        PlaygroundQuery playgroundQuery = QueryUtil.processPlaygroundQuery(modelQuery);
        HashMap params = new HashMap();
        playgroundQuery.getParams().forEach(item -> params.put(item.getField(), item.getValue()));
        SQLTranslateVo sqlTranslateVo = SQLTranslateVo.builder().dataModel(dataModel).playgroundQuery(playgroundQuery).translateConfig(TranslateConfig.builder().params(params).enableEmptyQuery(true).build()).build();
        return generateSqlExecute.generateSql(sqlTranslateVo);
    }

    private static PlaygroundQuery processPlaygroundQuery(ModelQuery modelQuery) {
        PlaygroundQuery playgroundQuery = new PlaygroundQuery();
        playgroundQuery.setResultType("sql");
        playgroundQuery.setDataType(modelQuery.getQueryInfo().getDataType());
        playgroundQuery.setShowType(Integer.valueOf(1));
        PlaygroundPage playgroundPage = new PlaygroundPage();
        playgroundPage.setPageNo(modelQuery.getPageNum().intValue());
        playgroundPage.setPageSize(modelQuery.getPageSize().intValue());
        playgroundQuery.setPage(playgroundPage);
        playgroundQuery.setDistinct(modelQuery.getQueryInfo().getDistinct().booleanValue());
        playgroundQuery.setDimensions(QueryUtil.adapterDimensions(modelQuery.getQueryInfo().getDimensions()));
        playgroundQuery.setMeasures(QueryUtil.adapterMeasures(modelQuery.getQueryInfo().getMeasures()));
        Map<String, String> paramsMap = modelQuery.getRequestColumn().stream().collect(Collectors.toMap(BaseField::getBandingField, BaseField::getParam));
        QueryUtil.adapterFilter(modelQuery.getQueryInfo().getFilter(), paramsMap);
        playgroundQuery.setFilter(modelQuery.getQueryInfo().getFilter());
        QueryUtil.adapterHavingFilter(modelQuery.getQueryInfo().getHavingFilters());
        playgroundQuery.setHavingFilters(modelQuery.getQueryInfo().getHavingFilters());
        playgroundQuery.setSortFields(QueryUtil.adapterSortFields(modelQuery.getOrderColumn()));
        playgroundQuery.setComputedFields(QueryUtil.adapterComputedFields(modelQuery.getQueryInfo().getComputedFields()));
        playgroundQuery.setParams(QueryUtil.adapterParams(modelQuery.getRequestColumn()));
        playgroundQuery.setShowFieldsMapping(QueryUtil.adapterShowFieldMapping(modelQuery.getReturnColumn()));
        return playgroundQuery;
    }

    private static Map<String, String> adapterShowFieldMapping(List<ReturnField> returnColumn) {
        return returnColumn.stream().collect(Collectors.toMap(BaseField::getBandingField, BaseField::getParam));
    }

    private static List<PlaygroundParamsField> adapterParams(List<ParamField> requestColumn) {
        ArrayList<PlaygroundParamsField> resList = new ArrayList<PlaygroundParamsField>();
        if (null != requestColumn) {
            requestColumn.forEach(param -> {
                if (10 == param.getOpType() || 11 == param.getOpType()) {
                    PlaygroundParamsField beforeParamsField = new PlaygroundParamsField();
                    beforeParamsField.setValue(String.format("${%s}", param.getParam().concat("_before")));
                    beforeParamsField.setRequired(Integer.valueOf(1));
                    beforeParamsField.setField(param.getParam().concat("_before"));
                    resList.add(beforeParamsField);
                    PlaygroundParamsField endParamsField = new PlaygroundParamsField();
                    endParamsField.setValue(String.format("${%s}", param.getParam().concat("_end")));
                    endParamsField.setRequired(Integer.valueOf(1));
                    endParamsField.setField(param.getParam().concat("_end"));
                    resList.add(endParamsField);
                } else {
                    PlaygroundParamsField playgroundParamsField = new PlaygroundParamsField();
                    playgroundParamsField.setValue(String.format("${%s}", param.getParam()));
                    playgroundParamsField.setRequired(Integer.valueOf(1));
                    playgroundParamsField.setField(param.getParam());
                    resList.add(playgroundParamsField);
                }
            });
        }
        return resList;
    }

    private static List<PlaygroundComputedField> adapterComputedFields(List<QueryComputedField> computedFields) {
        return computedFields.stream().map(field -> {
            PlaygroundComputedField computedField = new PlaygroundComputedField();
            computedField.setExpression(field.getExpression());
            computedField.setMeta(field.getMeta());
            computedField.setField(field.getField());
            computedField.setName(field.getName());
            computedField.setDataType(SQLConstants.FIELD_TYPE_REVERSE_MAP.get(field.getDataType()));
            return computedField;
        }).collect(Collectors.toList());
    }

    private static List<PlaygroundSortField> adapterSortFields(List<OrderField> orderColumn) {
        return orderColumn.stream().map(field -> {
            PlaygroundSortField sortField = new PlaygroundSortField();
            sortField.setField(field.getField());
            sortField.setOrder(field.getType());
            return sortField;
        }).collect(Collectors.toList());
    }

    private static void adapterHavingFilter(List<PlaygroundHavingFilter> havingFilters) {
        havingFilters.forEach(havingFilter -> havingFilter.getChildren().forEach(item -> item.setOperator(SQLConstants.OPERATOR_MAP.get(item.getOperator()))));
    }

    private static void adapterFilter(PlaygroundFilter filter, Map<String, String> paramsMap) {
        if (null == filter) {
            return;
        }
        if (null != filter.getOperator()) {
            filter.setOperator(SQLConstants.OPERATOR_MAP.get(filter.getOperator()));
        }
        if ("param".equals(filter.getRightType())) {
            filter.setRightValue(paramsMap.get(filter.getLeftValue()));
            if (StringUtils.containsIgnoreCase((CharSequence)filter.getOperator(), (CharSequence)"between")) {
                filter.setRightValue(String.format("%s_before#%s_end", paramsMap.get(filter.getLeftValue()), paramsMap.get(filter.getLeftValue())));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)filter.getChildren())) {
            filter.getChildren().forEach(f -> QueryUtil.adapterFilter(f, paramsMap));
        }
    }

    private static List<PlaygroundMeasureField> adapterMeasures(List<QueryMeasure> measures) {
        return measures.stream().map(m -> {
            PlaygroundMeasureField measureField = new PlaygroundMeasureField();
            measureField.setField(m.getField());
            measureField.setName(m.getName());
            measureField.setDataType(SQLConstants.FIELD_TYPE_REVERSE_MAP.get(m.getDataType()));
            measureField.setAggregator(m.getAggregator());
            return measureField;
        }).collect(Collectors.toList());
    }

    private static List<PlaygroundDimensionField> adapterDimensions(List<QueryDimension> dimensions) {
        return dimensions.stream().map(d -> {
            PlaygroundDimensionField dimensionField = new PlaygroundDimensionField();
            dimensionField.setField(d.getField());
            dimensionField.setName(d.getName());
            dimensionField.setDataType(SQLConstants.FIELD_TYPE_REVERSE_MAP.get(d.getDataType()));
            return dimensionField;
        }).collect(Collectors.toList());
    }

    private static DataModel processDataModel(Model model) {
        SqlTranslatorProvider queryProvider = ProviderFactory.getQueryProvider((String)SQLConstants.DB_MAP.get(model.getDataSourceType()));
        DataModel dataModel = new DataModel();
        BeanUtil.copyProperties((Object)model, (Object)dataModel, (String[])new String[0]);
        dataModel.setDsType(SQLConstants.DB_MAP.get(model.getDataSourceType()));
        dataModel.setMultiTenant(Integer.valueOf(0));
        HashMap tableIdCodeMap = new HashMap();
        HashMap fieldIdCodeMap = new HashMap();
        HashMap fieldIdUnionCodeMap = new HashMap();
        List tables = JSONObject.parseArray((String)JSONObject.toJSONString(model.getTables()), com.digiwin.dcc.model.dto.ModelTable.class);
        List coreTables = tables.stream().map(table -> {
            if (Objects.nonNull(table.getId())) {
                tableIdCodeMap.put(table.getId(), table.getCode());
            }
            ModelTable coreTable = new ModelTable();
            coreTable.setCode(table.getCode());
            coreTable.setName(table.getName());
            coreTable.setPath(table.getCode());
            coreTable.setType(Integer.valueOf(2));
            List coreFields = table.getFields().stream().map(field -> {
                ModelField coreField = new ModelField();
                coreField.setCode(field.getName());
                coreField.setDataType(queryProvider.transFieldType(field.getDataType()));
                if (Objects.nonNull(field.getId())) {
                    fieldIdCodeMap.put(field.getId(), field.getName());
                    fieldIdUnionCodeMap.put(field.getId(), table.getCode().concat("__").concat(field.getName()));
                }
                return coreField;
            }).collect(Collectors.toList());
            coreTable.setFields(coreFields);
            return coreTable;
        }).collect(Collectors.toList());
        dataModel.setTables(coreTables);
        if (CollectionUtil.isNotEmpty(model.getLinks())) {
            List coreLinks = model.getLinks().stream().map(link -> {
                ModelLink modelLink = (ModelLink)JSONObject.parseObject((String)link.toJSONString(), ModelLink.class);
                com.digiwin.dcc.core.entity.model.ModelLink coreLink = new com.digiwin.dcc.core.entity.model.ModelLink();
                coreLink.setSourceTable((String)tableIdCodeMap.get(modelLink.getSourceTable()));
                coreLink.setSourceField(QueryUtil.processLinkField(modelLink.getSourceField(), fieldIdCodeMap, ","));
                coreLink.setSourcePath((String)tableIdCodeMap.get(modelLink.getSourceTable()));
                coreLink.setTargetTable((String)tableIdCodeMap.get(modelLink.getTargetTable()));
                coreLink.setTargetField(QueryUtil.processLinkField(modelLink.getTargetField(), fieldIdCodeMap, ","));
                coreLink.setTargetPath((String)tableIdCodeMap.get(modelLink.getTargetTable()));
                coreLink.setUnionType(modelLink.getUnionType());
                coreLink.setFilter(QueryUtil.processLinkFilter(modelLink.getFilter() == null ? null : (PlaygroundFilter)JSONUtil.toBean((String)modelLink.getFilter(), PlaygroundFilter.class), fieldIdUnionCodeMap));
                coreLink.setLogical(modelLink.getLogical());
                return coreLink;
            }).collect(Collectors.toList());
            dataModel.setLinks(coreLinks);
        }
        return dataModel;
    }

    private static String processLinkField(String source, Map<Long, String> fieldIdCodeMap, String logic) {
        if (null == source) {
            return null;
        }
        List<String> list = Arrays.asList(source.split(logic));
        return CollectionUtil.join((Iterable)list.stream().map(field -> (String)fieldIdCodeMap.get(Long.parseLong(field))).collect(Collectors.toList()), (CharSequence)",");
    }

    private static PlaygroundFilter processLinkFilter(PlaygroundFilter filter, Map<Long, String> fieldIdUnionCodeMap) {
        if (null == filter) {
            return null;
        }
        filter.setLeftValue(null != filter.getLeftValue() ? fieldIdUnionCodeMap.get(Long.parseLong(filter.getLeftValue())) : null);
        if ("field".equals(filter.getRightType())) {
            filter.setRightValue(QueryUtil.processLinkField(filter.getRightValue(), fieldIdUnionCodeMap, "#"));
        }
        if (CollectionUtil.isNotEmpty((Collection)filter.getChildren())) {
            filter.getChildren().forEach(item -> QueryUtil.processLinkFilter(item, fieldIdUnionCodeMap));
        }
        return filter;
    }

    public static ModelQueryInfo transformHistoryData(ApiHistoryData historyData) {
        SqlTranslatorProvider queryProvider = ProviderFactory.getQueryProvider((String)SQLConstants.DB_MAP.get(historyData.getDataSourceType().toString()));
        ModelQueryInfo modelQueryInfo = new ModelQueryInfo();
        modelQueryInfo.setDataType(2);
        modelQueryInfo.setDistinct(false);
        List<QueryDimension> dimensions = historyData.getReturnColumn().stream().map(field -> {
            QueryDimension queryDimensionField = new QueryDimension();
            queryDimensionField.setField(field.getBandingField());
            queryDimensionField.setDataType(SQLConstants.FIELD_TYPE_MAP.get(queryProvider.transFieldType(field.getType())));
            return queryDimensionField;
        }).collect(Collectors.toList());
        modelQueryInfo.setDimensions(dimensions);
        PlaygroundFilter filter = new PlaygroundFilter();
        List children = historyData.getRequestColumn().stream().map(field -> {
            PlaygroundFilter child = new PlaygroundFilter();
            child.setLeftValue(field.getBandingField());
            child.setOperator(field.getOpType().toString());
            child.setRightType("param");
            return child;
        }).collect(Collectors.toList());
        filter.setChildren(children);
        modelQueryInfo.setFilter(filter);
        return modelQueryInfo;
    }

    public static void main(String[] args) throws Exception {
        ApiHistoryData historyData = new ApiHistoryData();
        historyData.setDataSourceType(0);
        ModelQueryInfo modelQueryInfo = QueryUtil.transformHistoryData(historyData);
        System.out.println(JSON.toJSONString((Object)modelQueryInfo));
    }
}

