/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.fastboot;

import com.digiwin.dcc.core.enums.DataSourceTypeEnum;
import com.digiwin.dcc.fastboot.FastbootConversionStrategy;
import com.digiwin.dcc.fastboot.HiveFastbootConversion;
import com.digiwin.dcc.fastboot.ImpalaFastbootConversion;
import com.digiwin.dcc.fastboot.MySqlFastbootConversion;
import com.digiwin.dcc.fastboot.OracleFastbootConversion;
import com.digiwin.dcc.fastboot.SqlServerFastbootConversion;
import com.digiwin.dcc.fastboot.StarRocksFastbootConversion;
import com.digiwin.dcc.model.dto.FastbootDTO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FastbootConvertio {
    private final Map<String, FastbootConversionStrategy> strategyMap = new HashMap<String, FastbootConversionStrategy>();

    public FastbootConvertio() {
        this.strategyMap.put(DataSourceTypeEnum.mysql.getType(), new MySqlFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.impala.getType(), new ImpalaFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.hive.getType(), new HiveFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.sqlServer.getType(), new SqlServerFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.oracle.getType(), new OracleFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.StarRocks.getType(), new StarRocksFastbootConversion());
    }

    public String convertDate(FastbootDTO fastbootDTO) {
        FastbootConversionStrategy strategy = this.strategyMap.get(fastbootDTO.getDbType());
        if (strategy == null) {
            throw new IllegalStateException("FastbootStrategy not set");
        }
        return strategy.convertDate(fastbootDTO);
    }

    public String substr(FastbootDTO fastbootDTO) {
        FastbootConversionStrategy strategy = this.strategyMap.get(fastbootDTO.getDbType());
        if (strategy == null) {
            throw new IllegalStateException("FastbootStrategy not set");
        }
        return strategy.substr(fastbootDTO);
    }

    public String concat(FastbootDTO fastbootDTO) {
        FastbootConversionStrategy strategy = this.strategyMap.get(fastbootDTO.getDbType());
        if (strategy == null) {
            throw new IllegalStateException("FastbootStrategy not set");
        }
        return strategy.concat(fastbootDTO);
    }

    public static void main(String[] args) {
    }

    private static void testConcat(String dbType) {
        FastbootConvertio fastbootConvertio = new FastbootConvertio();
        FastbootDTO fastbootDTO = new FastbootDTO();
        fastbootDTO.setDbType(dbType);
        fastbootDTO.setFunc(3);
        fastbootDTO.setParams(Arrays.asList("'123'", "'456'"));
        System.out.println("select " + fastbootConvertio.concat(fastbootDTO));
    }

    private static void testSubstr(String dbType) {
        FastbootConvertio fastbootConvertio = new FastbootConvertio();
        FastbootDTO fastbootDTO = new FastbootDTO();
        fastbootDTO.setDbType(dbType);
        fastbootDTO.setFunc(2);
        fastbootDTO.setParams(Arrays.asList("'12345'", "'2'", "'3'"));
        System.out.println("select " + fastbootConvertio.substr(fastbootDTO));
    }

    private static void testDate(String dbType) {
        FastbootConvertio fastbootConvertio = new FastbootConvertio();
        FastbootDTO fastbootDTO = new FastbootDTO();
        fastbootDTO.setDbType(dbType);
        fastbootDTO.setFormat("yyyymmdd");
        fastbootDTO.setFunc(0);
        fastbootDTO.setParams(Arrays.asList("'20240101'"));
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("yyyy-mm-dd");
        fastbootDTO.setParams(Arrays.asList("'2024-01-01'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("yyyy/mm/dd");
        fastbootDTO.setParams(Arrays.asList("'2024/01/01'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("ddmmyyyy");
        fastbootDTO.setParams(Arrays.asList("'01102024'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("dd-mm-yyyy");
        fastbootDTO.setParams(Arrays.asList("'01-10-2024'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("dd/mm/yyyy");
        fastbootDTO.setParams(Arrays.asList("'01/10/2024'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("mmddyyyy");
        fastbootDTO.setParams(Arrays.asList("'10012024'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("mm-dd-yyyy");
        fastbootDTO.setParams(Arrays.asList("'10-01-2024'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFormat("mm/dd/yyyy");
        fastbootDTO.setParams(Arrays.asList("'10/01/2024'"));
        fastbootDTO.setFunc(0);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
        fastbootDTO.setFunc(1);
        System.out.println("select " + fastbootConvertio.convertDate(fastbootDTO));
    }
}

