/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.fastboot;

import com.digiwin.dcc.fastboot.FastbootConversionStrategy;
import com.digiwin.dcc.model.dto.FastbootDTO;

public class SqlServerFastbootConversion
implements FastbootConversionStrategy {
    @Override
    public String convertDate(FastbootDTO fastbootDTO) {
        StringBuilder resultBuilder = new StringBuilder();
        if (fastbootDTO.getFunc() == 0) {
            resultBuilder.append("CONVERT(DATE,");
        } else if (fastbootDTO.getFunc() == 1) {
            resultBuilder.append("CONVERT(DATETIME,");
        } else {
            throw new IllegalArgumentException("Invalid fastboot convert date function value for SQL Server: " + fastbootDTO.getFunc());
        }
        if ("dd-mm-yyyy".equals(fastbootDTO.getFormat())) {
            resultBuilder.append(fastbootDTO.getParams().get(0)).append(", 105");
        } else if ("dd/mm/yyyy".equals(fastbootDTO.getFormat())) {
            resultBuilder.append(fastbootDTO.getParams().get(0)).append(", 103");
        } else if ("ddmmyyyy".equals(fastbootDTO.getFormat())) {
            String param = fastbootDTO.getParams().get(0);
            resultBuilder.append("CONCAT(SUBSTRING(").append(param).append(",0,3),'/',SUBSTRING(").append(param).append(",3,2),'/',SUBSTRING(").append(param).append(",5,4)), 103");
        } else if ("mmddyyyy".equals(fastbootDTO.getFormat())) {
            String param = fastbootDTO.getParams().get(0);
            resultBuilder.append("CONCAT(SUBSTRING(").append(param).append(",0,3),'/',SUBSTRING(").append(param).append(",3,2),'/',SUBSTRING(").append(param).append(",5,4))");
        } else {
            resultBuilder.append(fastbootDTO.getParams().get(0));
        }
        resultBuilder.append(")");
        return resultBuilder.toString();
    }

    @Override
    public String substr(FastbootDTO fastbootDTO) {
        StringBuilder resultBuilder = new StringBuilder("SUBSTRING(");
        for (String param : fastbootDTO.getParams()) {
            resultBuilder.append(param).append(",");
        }
        resultBuilder.deleteCharAt(resultBuilder.length() - 1);
        resultBuilder.append(")");
        return resultBuilder.toString();
    }

    @Override
    public String concat(FastbootDTO fastbootDTO) {
        StringBuilder resultBuilder = new StringBuilder("CONCAT(");
        for (String param : fastbootDTO.getParams()) {
            resultBuilder.append(param).append(",");
        }
        resultBuilder.deleteCharAt(resultBuilder.length() - 1);
        resultBuilder.append(")");
        return resultBuilder.toString();
    }
}

