/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.fastboot;

import com.digiwin.dcc.fastboot.FastbootConversionStrategy;
import com.digiwin.dcc.model.constant.FastbootEnum;
import com.digiwin.dcc.model.dto.FastbootDTO;
import java.util.Optional;

public class HiveFastbootConversion
implements FastbootConversionStrategy {
    @Override
    public String convertDate(FastbootDTO fastbootDTO) {
        Integer func = Optional.ofNullable(fastbootDTO.getFunc()).orElse(0);
        StringBuilder fastbootTextFormat = new StringBuilder();
        fastbootTextFormat.append(FastbootEnum.getValueByKey(fastbootDTO.getFormat(), fastbootDTO.getDbType()));
        if (fastbootDTO.getFunc() == 1) {
            fastbootTextFormat.append(" HH:mm:ss");
        }
        String format = String.format("from_unixtime(unix_timestamp(%s, '%s'), '%s')", fastbootDTO.getParams().get(0), fastbootTextFormat.toString(), "yyyy-MM-dd HH:mm:ss");
        return String.format("CAST(%s AS %s)", format, func == 1 ? "timestamp" : "date");
    }

    @Override
    public String substr(FastbootDTO fastbootDTO) {
        StringBuilder resultBuilder = new StringBuilder("SUBSTR(");
        for (String param : fastbootDTO.getParams()) {
            resultBuilder.append(param).append(",");
        }
        resultBuilder.deleteCharAt(resultBuilder.length() - 1);
        resultBuilder.append(")");
        return resultBuilder.toString();
    }

    @Override
    public String concat(FastbootDTO fastbootDTO) {
        StringBuilder resultBuilder = new StringBuilder("CONCAT(");
        for (String param : fastbootDTO.getParams()) {
            resultBuilder.append(param).append(",");
        }
        resultBuilder.deleteCharAt(resultBuilder.length() - 1);
        resultBuilder.append(")");
        return resultBuilder.toString();
    }
}

