/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.requesthelper.service.impl;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWRestfulHeader;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.requesthelper.service.IModuleInfoService;
import com.digiwin.app.requesthelper.service.pojo.MethodInfo;
import com.digiwin.app.requesthelper.service.pojo.ModuleInfo;
import com.digiwin.app.requesthelper.service.pojo.RequestHelperResult;
import com.digiwin.app.requesthelper.service.pojo.ServiceInfo;
import com.digiwin.app.requesthelper.service.pojo.StandardRestfulMethodInfo;
import com.digiwin.app.requesthelper.service.util.PathUtils;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModuleInfoService
implements IModuleInfoService {
    private static String MODULE_TYPE_NORMAL = "0";
    private static String MODULE_TYPE_STANDARD_RESTFUL = "2";
    private static String MODULE_TYPE_EAI = "3";
    private static Log log = LogFactory.getLog(ModuleInfoService.class);

    public RequestHelperResult<List<ModuleInfo>> getModuleInfos() {
        RequestHelperResult result = new RequestHelperResult();
        Map<String, Object> infos = this.getInfos();
        result.setInfo(infos);
        List<ModuleInfo> datas = this.getModuleInfosCore(false);
        result.setData(datas);
        return result;
    }

    private Map<String, Object> getInfos() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        String version = "unknown!";
        String fileName = "unknown!";
        try {
            version = DWService.class.getPackage().getImplementationVersion();
            if ("file".equalsIgnoreCase(DWService.class.getProtectionDomain().getCodeSource().getLocation().getProtocol())) {
                fileName = DWService.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            }
        }
        catch (Exception e) {
            log.error((Object)"ModuleInfoService getInfos failed!", (Throwable)e);
        }
        infos.put("version", version);
        infos.put("DWServiceFileName", fileName);
        return infos;
    }

    public List<ModuleInfo> getModuleInfos2() {
        return this.getModuleInfosCore(true);
    }

    private List<ModuleInfo> getModuleInfosCore(boolean includeMockService) {
        DWHeaderRepository repository = (DWHeaderRepository)SpringContextUtils.getBean((String)"DWHeaderRepository");
        List headers = repository.getAllHeader();
        List<ModuleInfo> result = this.createModuleInfos(headers, includeMockService);
        return result;
    }

    private List<ModuleInfo> createModuleInfos(List<DWHeader> headers, boolean includeMockService) {
        HashMap<String, ModuleInfo> targetModuleMap = new HashMap<String, ModuleInfo>();
        HashMap normalModuleMap = new HashMap();
        HashMap standardRestfulModuleMap = new HashMap();
        ModuleInfo eaiServiceType = new ModuleInfo(MODULE_TYPE_EAI, "EAI General Service");
        ModuleInfo eaiCallbackype = new ModuleInfo(MODULE_TYPE_EAI, "EAI Callback Service");
        for (DWHeader header : headers) {
            String moduleType;
            ModuleInfo moduleInfo;
            if (header instanceof DWEAIHeader) {
                moduleInfo = ((DWEAIHeader)header).isCallback() ? eaiCallbackype : eaiServiceType;
                this.buildEAIServiceInfo(moduleInfo, (DWEAIHeader)header, includeMockService);
                continue;
            }
            if (header instanceof DWRestfulHeader) {
                moduleType = MODULE_TYPE_STANDARD_RESTFUL;
                targetModuleMap = standardRestfulModuleMap;
            } else {
                moduleType = MODULE_TYPE_NORMAL;
                targetModuleMap = normalModuleMap;
            }
            moduleInfo = (ModuleInfo)targetModuleMap.get(header.getModuleName());
            if (moduleInfo == null) {
                moduleInfo = new ModuleInfo(moduleType, header.getModuleName());
                targetModuleMap.put(header.getModuleName(), moduleInfo);
            }
            if (header instanceof DWRestfulHeader) {
                this.buildRestfulServiceInfo(moduleInfo, (DWRestfulHeader)header, includeMockService);
                continue;
            }
            this.buildServiceInfo(moduleInfo, header, includeMockService);
        }
        ArrayList<ModuleInfo> mergedList = new ArrayList<ModuleInfo>();
        mergedList.addAll(normalModuleMap.values());
        mergedList.addAll(standardRestfulModuleMap.values());
        mergedList.add(eaiServiceType);
        mergedList.add(eaiCallbackype);
        return mergedList;
    }

    private void buildRestfulServiceInfo(ModuleInfo moduleInfo, DWRestfulHeader header, boolean includeMockService) {
        Class interfaceType = header.getServiceType();
        Method[] methods = interfaceType.getMethods();
        String servicePath = "";
        if (interfaceType.isAnnotationPresent(DWRequestMapping.class)) {
            DWRequestMapping typeRequestMapping = interfaceType.getAnnotation(DWRequestMapping.class);
            servicePath = typeRequestMapping.path();
        }
        for (Method method : methods) {
            if (!method.isAnnotationPresent(DWRequestMapping.class)) continue;
            DWRequestMapping requestMapping = method.getAnnotation(DWRequestMapping.class);
            ServiceInfo serviceInfo = new ServiceInfo(PathUtils.concatPath((String)servicePath, (String)requestMapping.path()));
            DWMethod dwMethod = new DWMethod(method);
            for (DWRequestMethod httpMethod : requestMapping.method()) {
                serviceInfo.addMethodInfo((MethodInfo)new StandardRestfulMethodInfo(dwMethod, httpMethod.toString()));
                moduleInfo.addServiceInfo(serviceInfo);
            }
        }
    }

    private void buildEAIServiceInfo(ModuleInfo moduleInfo, DWEAIHeader header, boolean includeMockService) {
        ServiceInfo serviceInfo = new ServiceInfo(header.getEAIServiceId());
        moduleInfo.addServiceInfo(serviceInfo);
    }

    private void buildServiceInfo(ModuleInfo moduleInfo, DWHeader header, boolean includeMockService) {
        String serviceName = header.getServiceName();
        ServiceInfo serviceInfo = new ServiceInfo(serviceName);
        this.buildMethodInfo(serviceInfo, header, includeMockService);
        moduleInfo.addServiceInfo(serviceInfo);
    }

    private void buildMethodInfo(ServiceInfo serviceInfo, DWHeader header, boolean includeMockService) {
        try {
            Map methodMap = header.getDWMethods();
            for (List methods : methodMap.values()) {
                for (DWMethod method : methods) {
                    MethodInfo methodInfo = new MethodInfo(method);
                    serviceInfo.addMethodInfo(methodInfo);
                }
            }
        }
        catch (Throwable e) {
            if (header != null) {
                String serviceName = header.getServiceType() != null ? header.getServiceType().getName() : String.format("%s.%s", header.getModuleName(), header.getServiceName());
                log.error((Object)String.format("\u5efa\u7f6e\u63a5\u53e3\u65b9\u6cd5\u4fe1\u606f  [%s] \u53d1\u751f\u4e25\u91cd\u9519\u8bef!", serviceName), e);
            }
            log.error((Object)"buildMethodInfo unknown error!", e);
        }
    }
}

