/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.dwapi.dwsys.service.IScheduleService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduleService
implements IScheduleService {
    Log _log = LogFactory.getLog(ScheduleService.class);
    DWScheduleContext scheduleContext = DWScheduleContext.getInstance();

    public Object getAvailableJobList() throws Exception {
        return this.scheduleContext.getAvailableJobList();
    }

    public Object executeJob(Map<String, Object> paramMap) throws Exception {
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return this.scheduleContext.executeJob(quartzInfo);
    }

    public Object addSchedule(Map<String, Object> paramMap) throws Exception {
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return this.scheduleContext.addSchedule(quartzInfo);
    }

    public Object addSchedules(List<Map<String, Object>> paramMap) throws Exception {
        return this.scheduleContext.addSchedules(paramMap);
    }

    public Object updateSchedule(Map<String, Object> paramMap) throws Exception {
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return this.scheduleContext.updateSchedule(quartzInfo);
    }

    public Object updateSchedules(List<Map<String, Object>> paramMap) throws Exception {
        return this.scheduleContext.updateSchedules(paramMap);
    }

    public Object updateScheduleExcludeEnableStatus(Map<String, Object> paramMap) throws Exception {
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return this.scheduleContext.updateScheduleExcludeEnableStatus(quartzInfo);
    }

    public Object updateSchedulesExcludeEnableStatus(List<Map<String, Object>> paramMap) throws Exception {
        return this.scheduleContext.updateSchedulesExcludeEnableStatus(paramMap);
    }

    public Object removeSchedule(List<String> scheduleIdList) throws Exception {
        return this.scheduleContext.deleteSchedule(scheduleIdList);
    }

    public Object getScheduleListByJob(DWPagableQueryInfo param) throws Exception {
        return this.scheduleContext.getScheduleList(param);
    }

    public Object getScheduleList(DWPagableQueryInfo param) throws Exception {
        return this.scheduleContext.getScheduleList(param);
    }

    public Object getScheduleInfo(String scheduleId) throws Exception {
        return this.scheduleContext.getScheduleInfo(scheduleId);
    }

    public Object getScheduleInfos(List<String> scheduleIds) throws Exception {
        return this.scheduleContext.getScheduleInfos(scheduleIds);
    }

    public Object getScheduleTimeInfo(String scheduleId) throws Exception {
        return this.scheduleContext.getScheduleTimeInfo(scheduleId);
    }

    public Object enableSchedule(List<String> scheduleIdList) throws Exception {
        return this.scheduleContext.setScheduleStatus("Y", scheduleIdList);
    }

    public Object disableSchedule(List<String> scheduleIdList) throws Exception {
        return this.scheduleContext.setScheduleStatus("N", scheduleIdList);
    }

    public Object getResultList(DWPagableQueryInfo queryInfo) throws Exception {
        Object result = this.scheduleContext.getScheduleRecordList(queryInfo);
        if (result == null) {
            return DWServiceResultBuilder.build((boolean)true, (String)"DWDao\u67e5\u8a62\u4e0d\u5230\u6578\u64da", (Object)result);
        }
        return DWServiceResultBuilder.build((Object)result);
    }

    public Object getResult(DWPagableQueryInfo queryInfo) throws Exception {
        Object result = this.scheduleContext.getScheduleRecordInfo(queryInfo);
        if (result == null) {
            return DWServiceResultBuilder.build((boolean)true, (String)"DWDao\u67e5\u8a62\u4e0d\u5230\u6578\u64da", (Object)result);
        }
        return DWServiceResultBuilder.build((Object)result);
    }

    public List<String> getProgramCodeList() throws Exception {
        DWPagableQueryInfo pagableQueryInfo = new DWPagableQueryInfo();
        pagableQueryInfo.setPageNumber(1);
        pagableQueryInfo.setPageSize(Integer.MAX_VALUE);
        pagableQueryInfo.setDistinct(true).setSelectFields(new String[]{"program_code"});
        Object o = this.getScheduleList(pagableQueryInfo);
        List<String> programCodeList = ((DWDataSet)o).getTable("dw_schedule").getRows().stream().filter(row -> row.get("program_code") != null).map(row -> row.get("program_code").toString()).collect(Collectors.toList());
        return programCodeList;
    }

    public Object recover(String workerId, String scheduleId) throws Exception {
        Object result = this.scheduleContext.recover(workerId, scheduleId);
        return result;
    }

    public Object recoverWorkerData(Map<String, Object> paramMap) throws Exception {
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        Object result = this.scheduleContext.recoverWorkerData(quartzInfo);
        return result;
    }

    public Object updateScheduleJobData(String scheduleAuthKey, Long tenantSid, String tenantId) throws Exception {
        DWServiceResult result = null;
        String originalScheduleAuthKey = "ZGFwLXNjaGVkdWxlLWF1dGgta2V5";
        byte[] scheduleAuthKeyBytes = Base64.getDecoder().decode(scheduleAuthKey);
        String decodedscheduleAuthKey = new String(scheduleAuthKeyBytes, StandardCharsets.UTF_8);
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        resultData.put("tenantSid", tenantSid);
        resultData.put("tenantId", tenantId);
        if (originalScheduleAuthKey.equals(decodedscheduleAuthKey)) {
            Map updatedScheduleJobData = this.scheduleContext.updateScheduleJobData(tenantSid, tenantId);
            resultData.putAll(updatedScheduleJobData);
            result = DWServiceResultBuilder.build((boolean)true, (String)"update shcedule job data completed", resultData);
        } else {
            result = DWServiceResultBuilder.build((boolean)false, (String)"schedule auth key authentication failed", resultData);
        }
        return result;
    }
}

