/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.container.DWCommand;
import com.digiwin.app.container.concurrent.DWExecutorService;
import com.digiwin.app.container.concurrent.DWSubmitInfo;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.dwapi.dwsys.service.IDMCService;
import com.digiwin.dwapi.dwsys.service.IThemeService;
import com.digiwin.utils.DWTenantUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class ThemeService
implements IThemeService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    private static final String TABLE_THEME = "dw_theme";
    private static final String KEY_PROP = "prop";
    private static final String KEY_STATE = "$state";
    private static final String KEY_VALUE = "value";
    private static final String KEY_FILE_ID = "fileid";
    private static final String KEY_USERID = "userid";
    private static final String STATEMENT_SELECT_THEME = "select * from dw_theme where 1=1 ${tenantsid}";
    private static final String STATEMENT_SELECT_FILELOG = "select * from dw_theme_filelog where create_time >= ? -${tenantsid}";
    private static final String STATEMENT_INSERT_THEME = "INSERT INTO dw_theme (prop,value,userid " + DWTenantUtils.getSqlTenantNameTag() + ") " + "VALUES (?, ?, ? " + DWTenantUtils.getSqlTenantValueTag() + ") " + "ON DUPLICATE KEY UPDATE " + "value" + "=?," + "userid" + "=?";
    private static final String STATEMENT_DELETE_THEME = "DELETE FROM dw_theme WHERE prop=? ${tenantsid}";
    Log log = LogFactory.getLog(ThemeService.class);
    private List<Map<String, String>> params;
    @Autowired
    IDMCService dmcService;

    public Object get() throws Exception {
        return DWServiceResultBuilder.build((boolean)true, (String)"\u67e5\u8a62\u4f01\u696d\u4e3b\u984c\u6210\u529f", (Object)this.dao.select(STATEMENT_SELECT_THEME, new Object[0]));
    }

    @Transactional(value="dw-transactionManager", propagation=Propagation.REQUIRED, rollbackForClassName={"DWException"})
    public Object post(List<Map<String, String>> params) throws Exception {
        String resultData = "";
        this.params = params;
        Map<String, String> previousFileIds = this.getPreviousFileIds();
        try {
            this.updateData();
            this.processFileIfSuccess(previousFileIds);
        }
        catch (Exception e) {
            this.processFileIfFail();
            throw e;
        }
        return DWServiceResultBuilder.build((boolean)true, (String)"\u4f01\u696d\u4e3b\u984c\u4fdd\u5b58\u6210\u529f", (Object)resultData);
    }

    private void updateData() {
        this.log.info((Object)"execute data into DB...");
        for (Map<String, String> param : this.params) {
            String prop = MapUtils.getString(param, (Object)KEY_PROP);
            String value = MapUtils.getString(param, (Object)KEY_VALUE);
            String state = MapUtils.getString(param, (Object)KEY_STATE);
            if (this.isCreate(state) || this.isUpdate(state)) {
                this.dao.update(STATEMENT_INSERT_THEME, new Object[]{prop, value, "", value, ""});
                continue;
            }
            if (!this.isDelete(state)) continue;
            this.dao.update(STATEMENT_DELETE_THEME, new Object[]{prop});
        }
    }

    private void processFileIfSuccess(Map<String, String> previousFileIds) {
        this.log.info((Object)"process file if success...");
        try {
            for (Map<String, String> param : this.params) {
                String prop;
                if (!this.isFile(param) || !previousFileIds.containsKey(prop = MapUtils.getString(param, (Object)KEY_PROP))) continue;
                this.deleteFile(previousFileIds.get(prop));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("error in process files at success status:" + e));
        }
    }

    private void processFileIfFail() throws Exception {
        this.log.info((Object)"process file if fail...");
        for (Map<String, String> param : this.params) {
            String state;
            if (!this.isFile(param) || !this.isCreate(state = MapUtils.getString(param, (Object)KEY_STATE)) && !this.isUpdate(state)) continue;
            String fileId = MapUtils.getString(param, (Object)KEY_VALUE);
            this.dmcService.insertFileLog(fileId, "\u4e3b\u984c\u4fdd\u5b58\u4f8b\u5916\uff0c\u672a\u80fd\u5982\u671f\u66f4\u65b0");
        }
        Set<String> deleteFileIds = this.getDeleteFileIds();
        for (String fileId : deleteFileIds) {
            this.deleteFile(fileId);
        }
    }

    @Async
    private void deleteFile(String fileId) throws Exception {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("fileId", fileId);
            DWCommand command = new DWCommand("DWSys", "IDMCService", "deleteFile", parameters);
            new DWExecutorService(5).sumbit(new DWSubmitInfo(command, DWServiceContext.getContext().getProfile()));
        }
        catch (Exception e) {
            this.log.error((Object)"error in deleting files");
            this.dmcService.insertFileLog(fileId, "file\u672a\u5982\u671f\u522a\u9664");
        }
    }

    private Map<String, String> getPreviousFileIds() {
        HashMap<String, String> filePropsMap = new HashMap<String, String>();
        for (Map<String, String> param : this.params) {
            if (!this.isFile(param)) continue;
            filePropsMap.put(MapUtils.getString(param, (Object)KEY_PROP), MapUtils.getString(param, (Object)KEY_VALUE));
        }
        List list = this.dao.select(STATEMENT_SELECT_THEME, new Object[0]);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map map : list) {
            String key = MapUtils.getString((Map)map, (Object)KEY_PROP);
            if (!filePropsMap.containsKey(MapUtils.getString((Map)map, (Object)KEY_PROP))) continue;
            result.put(key, MapUtils.getString((Map)map, (Object)KEY_VALUE));
        }
        return result;
    }

    private Set<String> getDeleteFileIds() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        List list = this.dao.select(STATEMENT_SELECT_FILELOG, new Object[]{sdf.format(new Date())});
        HashSet<String> result = new HashSet<String>();
        for (Map map : list) {
            result.add(MapUtils.getString((Map)map, (Object)KEY_FILE_ID));
        }
        return result;
    }

    private boolean isFile(Map<String, String> param) {
        return Boolean.parseBoolean(MapUtils.getString(param, (Object)"is_file", (String)"true"));
    }

    private boolean isCreate(String state) {
        return StringUtils.equals((CharSequence)state, (CharSequence)"c");
    }

    private boolean isUpdate(String state) {
        return StringUtils.equals((CharSequence)state, (CharSequence)"u");
    }

    private boolean isDelete(String state) {
        return StringUtils.equals((CharSequence)state, (CharSequence)"d");
    }
}

