/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.dwapi.dwsys.service.IMyHomeService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MyHomeService
implements IMyHomeService {
    Log _log = LogFactory.getLog(MyHomeService.class);
    @Autowired(required=false)
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private MessageSource messageSource;
    private static final String PROFILE_USERID = "userId";
    private static final String COLUMN_PK_USERID = "userid";
    private static final String TABLE_MYHOME = "dw_myhome";
    private static final String COLUMN_LEVEL = "level";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_PATH = "path";
    private static final String COLUMN_DATA_LEVEL_COMMON = "common";
    private static final String COLUMN_DATA_LEVEL_USER = "user";
    private static final String COLUMN_DATA_USERID_COMMON = "";
    private static final String TABLE_MYHOME_PARAMETER = "dw_myhome_parameter";
    private static final String COLUMN_PARA_NAME = "name";
    private static final String COLUMN_PARA_VALUE = "value";

    @Transactional(value="dw-transactionManager", propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object post(DWDataSet dataset) throws Exception {
        if (dataset == null || dataset.getTables().size() == 0) {
            throw new DWArgumentException("dataset", "dataset is null or empty!");
        }
        Map profile = DWServiceContext.getContext().getProfile();
        String userId = (String)profile.get(PROFILE_USERID);
        DWDataSet createUpdateMyHomeDataSet = new DWDataSet();
        DWDataSet deleteMyHomeDataSet = null;
        DWDataTable dwMyHomeCreateUpdateTable = createUpdateMyHomeDataSet.newTable(TABLE_MYHOME);
        if (dataset.containsTable(TABLE_MYHOME)) {
            DWDataTable dwMyHomeTable = dataset.getTable(TABLE_MYHOME);
            deleteMyHomeDataSet = new DWDataSet();
            for (Iterator myHomeRow : dwMyHomeTable.getRows()) {
                String myHomeLevel = (String)myHomeRow.getData().get(COLUMN_LEVEL);
                this.addUserIdFiled(myHomeLevel, (DWDataRow)myHomeRow, userId);
                dwMyHomeCreateUpdateTable.newRow(myHomeRow.getData());
            }
            deleteMyHomeDataSet = this.getDeleteDataSet(dataset);
        }
        if (dataset.containsTable(TABLE_MYHOME_PARAMETER)) {
            String myHomeParamLevel;
            DWDataTable dwMyHomeParamTable = dataset.getTable(TABLE_MYHOME_PARAMETER);
            DWDataTable dwMyHomeParamCreateUpdateTable = createUpdateMyHomeDataSet.newTable(TABLE_MYHOME_PARAMETER);
            for (DWDataRow myHomeParamRow : dwMyHomeParamTable.getRows()) {
                myHomeParamLevel = (String)myHomeParamRow.getData().get(COLUMN_LEVEL);
                this.addUserIdFiled(myHomeParamLevel, myHomeParamRow, userId);
                dwMyHomeParamCreateUpdateTable.newRow(myHomeParamRow.getData());
            }
            Iterator deletingParamRowIt = dwMyHomeParamTable.getRows().getIteratorOfRemovedRows();
            while (deletingParamRowIt.hasNext()) {
                DWDataRow myHomeParamDeleteRow = (DWDataRow)deletingParamRowIt.next();
                myHomeParamLevel = (String)myHomeParamDeleteRow.getData().get(COLUMN_LEVEL);
                this.addUserIdFiled(myHomeParamLevel, myHomeParamDeleteRow, userId);
                dwMyHomeParamCreateUpdateTable.newRow(myHomeParamDeleteRow.getData());
            }
        }
        if (deleteMyHomeDataSet != null) {
            this.delete(deleteMyHomeDataSet);
        }
        DWSQLExecutionResult resultData = this.dao.execute(createUpdateMyHomeDataSet);
        String resultMessage = this.messageSource.getMessage("msg001", null, null);
        boolean resultBoolean = true;
        return DWServiceResultBuilder.build((boolean)resultBoolean, (String)resultMessage, (Object)resultData);
    }

    @Transactional(value="dw-transactionManager", propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object delete(DWDataSet dataset) throws Exception {
        if (dataset == null || dataset.getTables().size() == 0) {
            throw new DWArgumentException("dataset", "dataset is null or empty!");
        }
        Map profile = DWServiceContext.getContext().getProfile();
        String userId = (String)profile.get(PROFILE_USERID);
        DWDataTable dwMyHomeTable = dataset.getTable(TABLE_MYHOME);
        Iterator deletingRowIt = dwMyHomeTable.getRows().getIteratorOfRemovedRows();
        DWDataRow myHomeRow = null;
        if (deletingRowIt.hasNext() && (myHomeRow = (DWDataRow)deletingRowIt.next()) != null) {
            String myHomeLevel = (String)myHomeRow.getData().get(COLUMN_LEVEL);
            if (StringUtils.isBlank((CharSequence)myHomeLevel)) {
                throw new DWArgumentException(COLUMN_LEVEL, "level is null!");
            }
            this.addUserIdFiled(myHomeLevel, myHomeRow, userId);
        }
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.addCascadeDeleting(TABLE_MYHOME, TABLE_MYHOME_PARAMETER);
        DWSQLExecutionResult resultData = null;
        resultData = this.dao.execute(dataset, option);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)resultData);
    }

    public Object get(Object params) throws Exception {
        if (params == null) {
            throw new DWArgumentException("params", "params is null!");
        }
        boolean isHasLevelData = true;
        Map paramsMap = (Map)params;
        if (!paramsMap.containsKey(COLUMN_LEVEL)) {
            throw new DWArgumentException(COLUMN_LEVEL, "level is missing!");
        }
        Map profile = DWServiceContext.getContext().getProfile();
        String userId = (String)profile.get(PROFILE_USERID);
        String myHomeLevel = (String)paramsMap.get(COLUMN_LEVEL);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName(TABLE_MYHOME);
        queryInfo.setSelectFields(Arrays.asList(COLUMN_LEVEL, COLUMN_TYPE, COLUMN_PATH));
        if (StringUtils.isNotBlank((CharSequence)myHomeLevel)) {
            queryInfo.addEqualInfo(COLUMN_LEVEL, (Object)myHomeLevel);
            this.addUserIdFiled(myHomeLevel, queryInfo, userId);
        } else {
            isHasLevelData = false;
            Object[] userIdFieldInfo = Arrays.asList(COLUMN_DATA_USERID_COMMON, userId).toArray();
            queryInfo.addFieldInfo(COLUMN_PK_USERID, DWQueryValueOperator.In, userIdFieldInfo);
        }
        DWDataSet datasetMyHome = this.dao.select(queryInfo);
        DWDataRowCollection myhomeDataRows = datasetMyHome.getTables().getPrimaryTable().getRows();
        int myHomeRowSize = myhomeDataRows.size();
        if (!isHasLevelData) {
            if (myHomeRowSize > 1) {
                myHomeLevel = COLUMN_DATA_LEVEL_USER;
                DWDataSet resultDataSet = new DWDataSet();
                DWDataTable myHomeDataTable = resultDataSet.newTable(TABLE_MYHOME);
                for (DWDataRow myHomeRow : myhomeDataRows) {
                    Map myHomeRowMap = myHomeRow.getData();
                    if (!myHomeRowMap.get(COLUMN_LEVEL).equals(COLUMN_DATA_LEVEL_USER)) continue;
                    myHomeDataTable.newRow(myHomeRowMap);
                    datasetMyHome = resultDataSet;
                    break;
                }
            } else if (myHomeRowSize == 1) {
                myHomeLevel = (String)myhomeDataRows.get(0).getData().get(COLUMN_LEVEL);
            }
        }
        if (myHomeRowSize > 0) {
            DWQueryInfo queryInfoMyHomeParam = new DWQueryInfo();
            queryInfoMyHomeParam.setTableName(TABLE_MYHOME_PARAMETER);
            queryInfoMyHomeParam.setSelectFields(Arrays.asList(COLUMN_PARA_NAME, COLUMN_PARA_VALUE));
            this.addUserIdFiled(myHomeLevel, queryInfoMyHomeParam, userId);
            queryInfoMyHomeParam.addEqualInfo(COLUMN_LEVEL, (Object)myHomeLevel);
            DWDataSet datasetMyHomeParam = this.dao.select(queryInfoMyHomeParam);
            datasetMyHome.getTables().add(datasetMyHomeParam.getTables().getPrimaryTable());
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)datasetMyHome);
    }

    private void addUserIdFiled(String myHomeLevel, DWQueryInfo queryInfo, String userId) {
        if (myHomeLevel.equals(COLUMN_DATA_LEVEL_USER)) {
            queryInfo.addEqualInfo(COLUMN_PK_USERID, (Object)userId);
        } else if (myHomeLevel.equals(COLUMN_DATA_LEVEL_COMMON)) {
            queryInfo.addEqualInfo(COLUMN_PK_USERID, (Object)COLUMN_DATA_USERID_COMMON);
        }
    }

    private void addUserIdFiled(String myHomeLevel, DWDataRow dwDataRow, String userId) {
        if (myHomeLevel.equals(COLUMN_DATA_LEVEL_USER)) {
            dwDataRow.set(COLUMN_PK_USERID, (Object)userId);
        } else if (myHomeLevel.equals(COLUMN_DATA_LEVEL_COMMON)) {
            dwDataRow.set(COLUMN_PK_USERID, (Object)COLUMN_DATA_USERID_COMMON);
        }
    }

    private DWDataSet getDeleteDataSet(DWDataSet dwDataSet) throws DWArgumentException {
        DWDataTable dwMyHomeTable = dwDataSet.getTable(TABLE_MYHOME);
        DWDataRowCollection dataRowColloection = dwMyHomeTable.getRows();
        Iterator deletingRowIt = dataRowColloection.getIteratorOfRemovedRows();
        DWDataSet resultDataSet = new DWDataSet();
        DWDataTable myHomeDataTable = resultDataSet.newTable(TABLE_MYHOME);
        while (deletingRowIt.hasNext()) {
            DWDataRow myHomeRow = (DWDataRow)deletingRowIt.next();
            Map myHomeRowMap = myHomeRow.getData();
            myHomeDataTable.newRow(myHomeRowMap);
        }
        return resultDataSet;
    }
}

