/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.dwapi.dwsys.model.Organization;
import com.digiwin.dwapi.dwsys.model.User;
import com.digiwin.dwapi.dwsys.service.IOrgService;
import com.digiwin.dwapi.dwsys.util.IAMInvokeService;
import com.digiwin.iam.HttpResponseModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrgService
implements IOrgService {
    Log log = LogFactory.getLog(OrgService.class);
    static String iamOrgAspectPath = DWApplicationConfigUtils.getProperty((String)"iamUrlOrgAspect");
    static String iamOrgUserinorgPath = DWApplicationConfigUtils.getProperty((String)"iamUrlOrgUserinorg");
    static String fullDataType = "full";

    public Object getOrg(Map<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Collection dataList = null;
        try {
            Map iamParam = new HashMap();
            iamParam = (Map)params.get("param");
            Map conditionMap = new HashMap();
            conditionMap = (Map)params.get("condition");
            String dataType = (String)conditionMap.get("dataType");
            HttpResponseModel iamResponse = (HttpResponseModel)IAMInvokeService.invokeIAM((String)iamOrgAspectPath, iamParam);
            int httpStatusCode = iamResponse.getHttpStatusCode();
            if (httpStatusCode == 400) {
                throw new DWBusinessException(iamResponse.getResponseBody());
            }
            if (httpStatusCode == 200) {
                Map resultRoot = new HashMap();
                String responseBody = iamResponse.getResponseBody();
                JSONArray orgArray = new JSONArray(responseBody);
                if (orgArray.length() > 0) {
                    Object userInOrgMap = this.getOrgData(orgArray, dataType);
                    resultRoot = (Map)((Map)userInOrgMap).get(0L);
                }
                dataList = resultRoot.values();
                response.put("success", true);
                response.put("description", "\u53d6\u5f97\u7d44\u7e54\u8cc7\u8a0a");
            }
        }
        catch (Exception e) {
            response.put("success", false);
            String messaage = e.getMessage();
            if (e.getMessage().startsWith("{\"message\":\"\u7121\u6cd5\u627e\u5230 ")) {
                messaage = "\u627e\u4e0d\u5230\u4f7f\u7528\u8005\u8cc7\u8a0a";
            } else if (e.getMessage().startsWith("{\"message\":\"\u7121\u6cd5\u53d6\u5f97\u6b0a\u9650\u8cc7\u6599")) {
                messaage = "\u627e\u4e0d\u5230\u7d44\u7e54\u8def\u5f91\u8cc7\u8a0a";
            }
            response.put("description", messaage);
        }
        response.put("datas", dataList);
        return response;
    }

    private Object getOrgData(JSONArray orgArray, String dataType) throws Exception {
        HashMap<Long, Map<Long, Object>> parentMap = new HashMap<Long, Map<Long, Object>>();
        ArrayList<User> children = null;
        for (int i = 0; i < orgArray.length(); ++i) {
            Map usersInOrg;
            JSONObject orgSidObj = orgArray.getJSONObject(i);
            Long orgSid = orgSidObj.getLong("sid");
            this.log.debug((Object)("=====  Node: " + orgSid + " ============="));
            Long orgParentSid = orgSidObj.getLong("parentSid");
            Organization iamOrg = new Organization();
            children = new ArrayList<User>();
            if (dataType.equals(fullDataType) && (usersInOrg = (Map)this.getUserInOrg(orgSid)).size() > 0) {
                for (Long sid : usersInOrg.keySet()) {
                    User user = (User)usersInOrg.get(sid);
                    children.add(user);
                }
                iamOrg.setChildren(children);
            }
            iamOrg.setChildren(children);
            iamOrg.setSid(orgSid);
            iamOrg.setId(orgSidObj.getString("label"));
            iamOrg.setTitle(orgSidObj.getString("name"));
            this.processParentMap(parentMap, orgParentSid, orgSid, iamOrg);
        }
        Object result = this.resortParentMap(parentMap);
        return result;
    }

    public Object getUserInOrg(Long orgSid) throws Exception {
        HashMap<Long, User> result = new HashMap<Long, User>();
        HashMap<String, Long> iamParam = new HashMap<String, Long>();
        iamParam.put("orgSid", orgSid);
        this.log.debug((Object)("find org(" + orgSid + ") users..."));
        HttpResponseModel iamResponse = (HttpResponseModel)IAMInvokeService.invokeIAM((String)iamOrgUserinorgPath, iamParam);
        int httpStatusCode = iamResponse.getHttpStatusCode();
        if (httpStatusCode == 400) {
            throw new DWBusinessException(iamResponse.getResponseBody());
        }
        if (httpStatusCode == 200) {
            String responseBody = iamResponse.getResponseBody();
            JSONArray usersArray = new JSONArray(responseBody);
            for (int i = 0; i < usersArray.length(); ++i) {
                JSONObject userSidObj = usersArray.getJSONObject(i);
                Long sid = userSidObj.getLong("userSid");
                User iamUser = new User();
                iamUser.setSid(sid);
                iamUser.setId(userSidObj.getString("userId"));
                iamUser.setTitle(userSidObj.getString("userName"));
                this.log.debug((Object)("org(" + orgSid + ")" + "has user:" + userSidObj.getString("userId")));
                result.put(sid, iamUser);
            }
        }
        return result;
    }

    private void processParentMap(Map<Long, Map<Long, Object>> parentMap, Long orgParentSid, Long orgSid, Organization iamOrg) {
        Map<Object, Object> mapTemp = parentMap.containsKey(orgParentSid) ? parentMap.get(orgParentSid) : new HashMap();
        mapTemp.put(orgSid, iamOrg);
        parentMap.put(orgParentSid, mapTemp);
    }

    private Object resortParentMap(Map<Long, Map<Long, Object>> source) {
        HashMap tempMap = new HashMap();
        HashMap<Long, Map<Long, Object>> sourceTemp = new HashMap<Long, Map<Long, Object>>();
        sourceTemp.putAll(source);
        Set childKeys = sourceTemp.keySet();
        if (childKeys.size() > 0) {
            for (Long orgSid : childKeys) {
                this.log.debug((Object)("[resortParentMap] process orgSid:" + orgSid));
                if (source.containsKey(orgSid)) {
                    Object orgValue = source.get(orgSid);
                    this.log.debug((Object)("[resortParentMap]   +:" + orgSid + ",value:" + orgValue));
                    orgValue = this.findChlid(source, orgValue);
                    continue;
                }
                this.log.debug((Object)("[resortParentMap]   +:" + orgSid + " not found, maybe processed"));
            }
        }
        return source;
    }

    private Object findChlid(Map<Long, Map<Long, Object>> source, Object child) {
        Map childValue = (Map)child;
        Set childKeys = childValue.keySet();
        if (childKeys.size() > 0) {
            this.log.debug((Object)("[processChild] child:" + childValue));
            for (Map.Entry orgEntry : childValue.entrySet()) {
                Long innerOrgSid = (Long)orgEntry.getKey();
                Organization orgValue = (Organization)orgEntry.getValue();
                this.log.debug((Object)("       + child inner:" + innerOrgSid + ",original orgValue:" + orgValue));
                if (orgValue == null || !source.containsKey(innerOrgSid)) continue;
                Object innerOrgValue = this.findChlid(source, source.get(innerOrgSid));
                if (innerOrgValue instanceof Map) {
                    orgValue.getChildren().addAll(((Map)innerOrgValue).values());
                }
                childValue.replace(innerOrgSid, orgValue);
                this.log.debug((Object)("       + " + innerOrgSid + ",new value:" + orgValue));
                source.remove(innerOrgSid);
            }
        }
        return child;
    }
}

