/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.dwapi.dwsys.service.ITenantScheduleBatchService;
import com.digiwin.iam.HttpConnectionManager;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.digiwin.utils.DWTenantUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

public class TenantScheduleBatchService
implements ITenantScheduleBatchService {
    Log _log = LogFactory.getLog(TenantScheduleBatchService.class);
    @Autowired
    private MessageSource messageSource;
    private static final String _CLASSTAG = "[TenantScheduleBatchService]";
    private static final String _App_Id = DWApplicationConfigUtils.getProperty((String)"appId");
    private static final String _CAC_URL = DWApplicationConfigUtils.getProperty((String)"cacUrl", (String)"");
    private static final String _key_IAM_TenantSid = DWTenantUtils.getIAMTenantSidKey();
    private static final String _CAC_PATH_AUTHORIZED_TENANT_APP = _CAC_URL + "/api/cac/v4/authorizations" + "/tenants/{tenantId}/goods/{goodsCode}";
    private static final String _IAM_PATH_APP_TENANT = "/api/iam/v2/app/{appId}/tenants";
    private static final String _IAM_PATH_TENANT_AP = "/api/iam/v2/user/tenant/application";
    private static final String _SQL_schedule_select_of_enabled = " select schedule_id from dw_schedule WHERE enable_status ='Y' " + DWTenantUtils.getTenantTagByColumnName();
    private static final String _SQL_schedule_select_of_disabled = " select schedule_id from dw_schedule WHERE enable_status ='N' and is_off_by_schedule = 'Y' " + DWTenantUtils.getTenantTagByColumnName();
    private static final String _SQL_is_off_by_schedule = "UPDATE dw_schedule SET is_off_by_schedule= 'Y' WHERE enable_status = 'Y' " + DWTenantUtils.getTenantTagByColumnName();
    private static final String _SQL_enable_schedule = "UPDATE dw_schedule SET is_off_by_schedule = 'N' WHERE enable_status = 'N' AND is_off_by_schedule = 'Y'" + DWTenantUtils.getTenantTagByColumnName();
    private static final SimpleDateFormat _scheduleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    DWScheduleContext scheduleContext = DWScheduleContext.getInstance();
    private static final String _key_ExpiredTime = "expiredTime";
    private static final String _key_map_tenantSid = "tenantSid";
    @Autowired(required=false)
    @Qualifier(value="dw-dao")
    private DWDao dao;

    public Object getAppList() throws Exception {
        ArrayList result = new ArrayList();
        List tenantsList = (List)this.getTenantList();
        HashMap<String, Object> appTemp = new HashMap<String, Object>();
        Map<Object, Object> authInfo = new HashMap();
        Map appInfo = (Map)this.getAppInfo(_App_Id);
        boolean isInnerApp = (Boolean)appInfo.get("inside");
        if (!isInnerApp) {
            for (Map tenantInfoTemp : tenantsList) {
                String tenantId = (String)tenantInfoTemp.get("id");
                authInfo = this.getAuth(tenantId, _App_Id);
                appTemp = new HashMap();
                appTemp.put("tid", tenantId);
                appTemp.put("tsid", ((Number)tenantInfoTemp.get("sid")).longValue());
                appTemp.put(_key_ExpiredTime, authInfo.getOrDefault(_key_ExpiredTime, null));
                result.add(appTemp);
            }
        }
        return result;
    }

    public Object getAppInfo() throws Exception {
        Map appInfo = (Map)this.getAppInfoById(_App_Id);
        return appInfo;
    }

    public Object getAppInfo(String appId) throws Exception {
        Map appInfo = (Map)this.getAppInfoById(appId);
        return appInfo;
    }

    public Object getAppInfoById(String appId) throws Exception {
        String userToken = DWServiceContext.getContext().getToken();
        List appList = (List)this.getSourceAppList(appId, userToken);
        Map<String, Object> appInfo = this.getAppInfo(appList, appId);
        return appInfo;
    }

    public Object getAppInfo(String appId, String userToken) throws Exception {
        List appList = (List)this.getSourceAppList(appId, userToken);
        Map<String, Object> appInfo = this.getAppInfo(appList, appId);
        return appInfo;
    }

    public Object getTenantList() throws Exception {
        List result = new ArrayList();
        List tenantsList = (List)this.getSourceTenants();
        result = (List)this.getTenantInfo(tenantsList, _App_Id);
        return result;
    }

    private Object getSourceTenants() throws Exception {
        HttpResponseModel responseModel;
        int responseStatusCode;
        ArrayList result = new ArrayList();
        String token = DWServiceContext.getContext().getToken();
        ServiceModel serviceModel = new ServiceModel();
        String invokeURL = _IAM_PATH_APP_TENANT.replaceAll("\\{appId\\}", _App_Id);
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(new HashMap());
        serviceModel.setRequestMethod(DWRequestMethod.GET);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            serviceModel.setToken(token);
        }
        if ((responseStatusCode = (responseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel)).getHttpStatusCode()) == 200) {
            ArrayList readValue;
            String responseStr = responseModel.getResponseBody();
            result = readValue = (ArrayList)new ObjectMapper().readValue(responseStr, ArrayList.class);
        }
        return result;
    }

    private Object getTenantInfo(List<Map<String, Object>> tenantsList, String appId) {
        ArrayList result = new ArrayList();
        for (Map<String, Object> tenantInfoTemp : tenantsList) {
            HashMap<String, Object> tenant = new HashMap<String, Object>();
            tenant.put("id", tenantInfoTemp.get("id"));
            tenant.put("sid", tenantInfoTemp.get("sid"));
            tenant.put("name", tenantInfoTemp.get("name"));
            tenant.put("isConfirm", tenantInfoTemp.get("isConfirm"));
            tenant.put("isOpen", tenantInfoTemp.get("isConfirm"));
            result.add(tenant);
        }
        return result;
    }

    private Object getSourceAppList(String appId, String token) throws Exception {
        ArrayList result = new ArrayList();
        HttpResponseModel responseModel = this.getTenantApplication(appId, token);
        int responseStatusCode = responseModel.getHttpStatusCode();
        if (responseStatusCode == 200) {
            ArrayList readValue;
            String responseStr = responseModel.getResponseBody();
            result = readValue = (ArrayList)new ObjectMapper().readValue(responseStr, ArrayList.class);
        }
        return result;
    }

    private Map<String, Object> getAppInfo(List<Map<String, Object>> appList, String appId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String iamAppId = "";
        for (Map<String, Object> appInfoTemp : appList) {
            iamAppId = (String)appInfoTemp.get("id");
            if (!StringUtils.isNotBlank((CharSequence)iamAppId) || !iamAppId.equals(appId)) continue;
            result.put("id", appId);
            result.put(_key_ExpiredTime, appInfoTemp.get(_key_ExpiredTime));
            result.put("expired", appInfoTemp.get("expired"));
            result.put("inside", appInfoTemp.get("inside"));
            this._log.debug((Object)("Find id(" + appId + "), get id(" + iamAppId + ") expired=" + appInfoTemp.get("expired")));
            break;
        }
        return result;
    }

    public Map<String, Object> getAuth(String tenantId, String appId) throws IOException, DWBusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HttpResponseModel authModel = this.getCACAuthorization(tenantId, appId);
        int statusCode = authModel.getHttpStatusCode();
        if (statusCode == 200) {
            String responseBody = authModel.getResponseBody();
            if (StringUtils.isNotBlank((CharSequence)responseBody)) {
                JSONObject responseObject = new JSONObject(responseBody);
                String expiredTime = responseObject.getString(_key_ExpiredTime);
                result.put(_key_ExpiredTime, expiredTime);
            } else {
                this._log.debug((Object)("[TenantScheduleBatchService][getAuth] find auth:tenantId=" + tenantId + ",responseBody no data(iam code:" + statusCode + ")"));
            }
        } else {
            this._log.debug((Object)("[TenantScheduleBatchService][getAuth] find auth:tenantId=" + tenantId + ",no data(iam code:" + statusCode + ")"));
        }
        return result;
    }

    private HttpResponseModel getCACAuthorization(String tenantId, String appId) throws IOException, DWBusinessException {
        HttpResponseModel result = null;
        if (StringUtils.isBlank((CharSequence)_CAC_URL)) {
            throw new DWRuntimeException("missing cacUrl setting");
        }
        String cacFullAuthUrl = _CAC_PATH_AUTHORIZED_TENANT_APP.replace("{tenantId}", tenantId).replace("{goodsCode}", appId);
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        CloseableHttpClient httpClient = HttpConnectionManager.getHttpClient((HttpRequestModel)requestModel);
        HttpGet get = new HttpGet(cacFullAuthUrl);
        String responseBody = "";
        int httpStatusCode = -1;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            httpStatusCode = response.getStatusLine().getStatusCode();
            try (InputStream responseStream = response.getEntity().getContent();){
                if (responseStream != null) {
                    responseBody = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                }
            }
        }
        result = new HttpResponseModel(httpStatusCode, responseBody);
        return result;
    }

    public Object postStop() throws Exception {
        Object result = null;
        List appList = (List)this.getAppList();
        if (appList.size() > 0) {
            Map profile = DWServiceContext.getContext().getProfile();
            Long orgTenSid = (Long)((Object)profile.getOrDefault(_key_IAM_TenantSid, ""));
            String expiredTimeTemp = "";
            Calendar calNow = Calendar.getInstance();
            String logStr = "[TenantScheduleBatchService] [appScheduleStop] tenantsid=%d(%s) ";
            Calendar calApp = Calendar.getInstance();
            ArrayList<Long> expiredTenantList = new ArrayList<Long>();
            for (Map tenantInfoTemp : appList) {
                this._log.debug((Object)("tsid=" + tenantInfoTemp.get("tsid")));
                Long tenantSid = (Long)tenantInfoTemp.get("tsid");
                expiredTimeTemp = tenantInfoTemp.getOrDefault(_key_ExpiredTime, "");
                if (!StringUtils.isNotBlank((CharSequence)expiredTimeTemp)) continue;
                calApp.setTime(_scheduleDateFormat.parse(expiredTimeTemp));
                if (calApp.before(calNow)) {
                    expiredTenantList.add(tenantSid);
                    this._log.debug((Object)String.format(logStr + " is stopped", tenantSid, expiredTimeTemp));
                    continue;
                }
                this._log.debug((Object)String.format(logStr + " is not exprired", tenantSid, expiredTimeTemp));
            }
            if (expiredTenantList.size() > 0) {
                HashMap<String, ArrayList<Long>> expiredTenant = new HashMap<String, ArrayList<Long>>();
                expiredTenant.put(_key_map_tenantSid, expiredTenantList);
                result = this.appScheduleStop(expiredTenant);
            }
            profile.put(_key_IAM_TenantSid, orgTenSid);
            DWServiceContext.getContext().setProfile(profile);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), result);
    }

    public Object postStop(Object params) throws Exception {
        this._log.debug((Object)"[TenantScheduleBatchService] postStop(Object params)");
        Object result = this.appScheduleStop(params);
        if (result instanceof DWServiceResult) {
            return result;
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object appScheduleStop(Object params) throws Exception {
        this._log.debug((Object)"[TenantScheduleBatchService] appScheduleStop(List tenantList)");
        if (params == null) {
            return DWServiceResultBuilder.build((boolean)false, (String)this.messageSource.getMessage("msg011", null, null), null);
        }
        Map paramsMap = (Map)params;
        ArrayList tenantList = paramsMap.getOrDefault(_key_map_tenantSid, null);
        ArrayList result = new ArrayList();
        Map profile = DWServiceContext.getContext().getProfile();
        List<Object> scheduleIdList = new ArrayList();
        List<Map<String, Object>> dbResult = new ArrayList();
        String logStr = "[TenantScheduleBatchService][appScheduleStop] tenantsid=%d ";
        for (Object obj : tenantList) {
            Object success;
            HashMap<String, Object> resultDetail = new HashMap<String, Object>();
            Long tenantSid = ((Number)obj).longValue();
            this._log.debug((Object)String.format(logStr + " --> processing...", tenantSid));
            profile.put(_key_IAM_TenantSid, tenantSid);
            DWServiceContext.getContext().setProfile(profile);
            dbResult = this.dao.select(_SQL_schedule_select_of_enabled, new Object[0]);
            int count = dbResult.size();
            if (count > 0) {
                scheduleIdList = this.getScheduleList(dbResult);
                this.dao.update(_SQL_is_off_by_schedule, new Object[0]);
                success = this.scheduleContext.setScheduleStatus("N", scheduleIdList);
                this._log.debug((Object)String.format(logStr + " --> stopped", tenantSid));
            } else {
                success = true;
                this._log.debug((Object)String.format(logStr + " --> no schedule", tenantSid));
            }
            resultDetail.put(_key_map_tenantSid, tenantSid);
            resultDetail.put("ScheduleStopStatus", success);
            resultDetail.put("scheduleCount", count);
            result.add(resultDetail);
        }
        return result;
    }

    public Object postStart(Object params) throws Exception {
        this._log.debug((Object)"[TenantScheduleBatchService] postStart(Object params)");
        Object result = this.scheduleStart(params);
        if (result instanceof DWServiceResult) {
            return result;
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object scheduleStart(Object params) throws Exception {
        this._log.debug((Object)"[TenantScheduleBatchService] scheduleStart(List tenantList)");
        if (params == null) {
            return DWServiceResultBuilder.build((boolean)false, (String)this.messageSource.getMessage("msg011", null, null), null);
        }
        Map paramsMap = (Map)params;
        ArrayList tenantIdList = paramsMap.getOrDefault("tenantIdList", null);
        ArrayList tenantSidList = paramsMap.getOrDefault(_key_map_tenantSid, null);
        ArrayList result = new ArrayList();
        Map profile = DWServiceContext.getContext().getProfile();
        List<Object> scheduleIdList = new ArrayList();
        List<Map<String, Object>> dbResult = new ArrayList();
        String logStr = "[TenantScheduleBatchService][scheduleStart] tenantsid=%d ";
        for (int i = 0; i < tenantSidList.size(); ++i) {
            Object success;
            Object tenantSidObject = tenantSidList.get(i);
            HashMap<String, Object> resultDetail = new HashMap<String, Object>();
            Long tenantSid = ((Number)tenantSidObject).longValue();
            this._log.debug((Object)String.format(logStr + " --> processing...", tenantSid));
            profile.put(_key_IAM_TenantSid, tenantSid);
            if (tenantIdList != null && tenantIdList.size() == tenantSidList.size()) {
                profile.put(DWTenantUtils.getIamTenantIdKey(), tenantIdList.get(i));
            }
            DWServiceContext.getContext().setProfile(profile);
            dbResult = this.dao.select(_SQL_schedule_select_of_disabled, new Object[0]);
            int count = dbResult.size();
            if (count > 0) {
                scheduleIdList = this.getScheduleList(dbResult);
                this.dao.update(_SQL_enable_schedule, new Object[0]);
                success = this.scheduleContext.setScheduleStatus("Y", scheduleIdList);
                this._log.debug((Object)String.format(logStr + " --> started", tenantSid));
            } else {
                success = true;
                this._log.debug((Object)String.format(logStr + " --> no schedule", tenantSid));
            }
            resultDetail.put(_key_map_tenantSid, tenantSid);
            resultDetail.put("ScheduleStartStatus", success);
            resultDetail.put("scheduleCount", count);
            result.add(resultDetail);
        }
        return result;
    }

    private List<String> getScheduleList(List<Map<String, Object>> dataList) {
        ArrayList<String> scheduleIdList = new ArrayList<String>();
        String scheduleId = "";
        for (Map<String, Object> dataRow : dataList) {
            scheduleId = (String)dataRow.get("schedule_id");
            scheduleIdList.add(scheduleId);
        }
        return scheduleIdList;
    }

    public HttpResponseModel getTenantApplication(String appId, String token) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(_IAM_PATH_TENANT_AP);
        serviceModel.setParams(new HashMap());
        serviceModel.setRequestMethod(DWRequestMethod.GET);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            serviceModel.setToken(token);
        }
        HttpResponseModel iamResponse = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        return iamResponse;
    }
}

