/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.sql.CustomizeFieldUtil;
import com.digiwin.dwapi.dwsys.service.ICustomizeFieldService;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class CustomizeFieldService
implements ICustomizeFieldService {
    private static Log log = LogFactory.getLog(CustomizeFieldService.class);
    @Autowired(required=false)
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private MessageSource messageSource;
    private static final String _tag_Tenantsid = DWTenantUtils.getTenantTagByColumnName();
    private static final String _TABLE_MASTER = "dw_customize_field";
    private static final String _Field_Config_Id = "config_id";
    private static final String _Field_Id = "field_id";
    private static final String _Field_Table_Name = "table_name";
    private static final String _ColumnName_Field = "cust_field";

    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object post(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        paramsMap.put("$state", "C");
        DWDataSet dataset = new DWDataSet();
        DWDataTable customizeFieldDWTable = dataset.newTable(_TABLE_MASTER);
        customizeFieldDWTable.newRow(paramsMap);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWSQLExecutionResult result = this.dao.execute(dataset, option);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object put(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        if (!paramsMap.containsKey(_Field_Config_Id)) {
            throw new DWArgumentException(_Field_Config_Id, "config_id is not existed!");
        }
        DWDataSet dataset = new DWDataSet();
        DWDataTable customizeFieldDWTable = dataset.newTable(_TABLE_MASTER);
        DWDataRow configFileRow = customizeFieldDWTable.newRow(paramsMap);
        configFileRow.set("$state", (Object)"U");
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWSQLExecutionResult result = this.dao.execute(dataset, option);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackForClassName={"Exception"})
    public Object delete(Object params) throws Exception {
        this.checkParam(params);
        DWSQLExecutionResult result = new DWSQLExecutionResult();
        Map paramsMap = (Map)params;
        Long configId = null;
        if (!paramsMap.containsKey(_Field_Config_Id)) {
            throw new DWArgumentException(_Field_Config_Id, "config_id is not existed!");
        }
        configId = this.parseLong(paramsMap.get(_Field_Config_Id));
        String tableName = (String)paramsMap.get(_Field_Table_Name);
        String fieldId = (String)paramsMap.get(_Field_Id);
        boolean isFieldUsed = this.checkIfFieldUsed(tableName, fieldId);
        if (isFieldUsed) {
            throw new DWBusinessException("msg410", this.messageSource.getMessage("msg410", null, null));
        }
        DWDataSet dataset = new DWDataSet();
        DWDataTable customizeFieldDWTable = dataset.newTable(_TABLE_MASTER);
        customizeFieldDWTable.newRow().set(_Field_Config_Id, (Object)configId).setState("D");
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        result = this.dao.execute(dataset, option);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object get(Object params) throws Exception {
        this.checkParam(params);
        Map paramsMap = (Map)params;
        if (!paramsMap.containsKey(_Field_Table_Name)) {
            throw new DWArgumentException(_Field_Table_Name, "table_name is not existed!");
        }
        List targetTables = (List)paramsMap.get(_Field_Table_Name);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            for (String tableName : targetTables) {
                DWQueryInfo queryInfo = new DWQueryInfo();
                queryInfo.setTableName(_TABLE_MASTER);
                queryInfo.addEqualInfo(_Field_Table_Name, (Object)tableName);
                DWDataSet dataset = this.dao.select(queryInfo, option);
                List<Map<String, Object>> rowList = this.dataTableToList(dataset.getTable(_TABLE_MASTER).getRows());
                result.put(tableName, rowList);
            }
        }
        catch (Exception e) {
            String excpMessage = e.getMessage();
            StringBuffer message = new StringBuffer("select customize field failed! ");
            if (StringUtils.isNotBlank((CharSequence)excpMessage)) {
                message.append(CustomizeFieldService.getLimit(excpMessage, 60));
            }
            log.error((Object)message, (Throwable)e);
            result.put("dw-message-error", message);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), result);
    }

    private void checkParam(Object params) throws Exception {
        if (params == null) {
            throw new DWArgumentException("params", "params is null!");
        }
    }

    public List<Map<String, Object>> dataTableToList(DWDataRowCollection dwDataRowCollection) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map rowMap = new HashMap();
        for (DWDataRow dwDataRow : dwDataRowCollection) {
            rowMap = dwDataRow.getData();
            result.add(rowMap);
        }
        return result;
    }

    public boolean checkIfFieldUsed(String tableName, String fieldId) throws Exception {
        Long count;
        String _SQL_CustomizeField_select_existed_fieldId = " select count(1) as total from " + tableName + " where JSON_CONTAINS_PATH( " + _ColumnName_Field + " , 'one' , ?)  " + _tag_Tenantsid + " limit 0, 1";
        List data = this.dao.select(_SQL_CustomizeField_select_existed_fieldId, new Object[]{"$." + fieldId});
        boolean result = false;
        if (data != null && data.size() > 0 && (count = Long.valueOf(String.valueOf(((Map)data.get(0)).get("total")))) > 0L) {
            result = true;
        }
        return result;
    }

    private long parseLong(Object value) {
        long result = 0L;
        if (value != null && !value.equals("")) {
            result = Double.class.isInstance(value) ? ((Double)value).longValue() : (Long.class.isInstance(value) ? (Long)value : Long.parseLong(value.toString()));
        }
        return result;
    }

    public Object deleteMetadataCache(Object params) throws Exception {
        int deletedCount;
        this.checkParam(params);
        Map paramsMap = (Map)params;
        String tableName = (String)paramsMap.get(_Field_Table_Name);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tableName", tableName);
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            ArrayList custFields;
            Map tenantData = (Map)CustomizeFieldUtil.getMetadataCacheByTenant();
            deletedCount = 0;
            if (tenantData != null && tenantData.containsKey(tableName) && (custFields = (ArrayList)tenantData.get(tableName)) != null) {
                deletedCount = custFields.size();
                tenantData.remove(tableName);
                result.put("removed", true);
            }
        } else {
            throw new DWArgumentException(_Field_Table_Name, this.messageSource.getMessage("msg411", null, null));
        }
        result.put("count", deletedCount);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), result);
    }

    private static String getLimit(String value, int length) {
        StringBuffer data = new StringBuffer(value);
        if (data.length() > length) {
            data.setLength(length);
            data.append("...");
        }
        return data.toString();
    }
}

