/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.dwapi.dwsys.service.IReportService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ReportService
implements IReportService {
    private static String frUrlKanbanUrlInfo = DWApplicationConfigUtils.getProperty((String)"frUrlKanbanUrlInfo");

    public Object getListLanguage(String language) throws Exception {
        String product = DWApplicationConfigUtils.getProperty((String)"appId");
        return this.getListLanguage(language, product);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getListLanguage(String language, String product) throws Exception {
        String[] reportApiArray;
        String reportApiUrl = DWApplicationConfigUtils.getProperty((String)"frUrl");
        ArrayList res = new ArrayList();
        if (reportApiUrl == null || reportApiUrl.isEmpty()) {
            return DWServiceResultBuilder.build(res);
        }
        for (String reportApi : reportApiArray = reportApiUrl.split(",")) {
            Gson gson = new GsonBuilder().create();
            Map responseObject = null;
            try (CloseableHttpClient httpClient = null;){
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
                connectionManager.setDefaultMaxPerRoute(1);
                connectionManager.setMaxTotal(1);
                RequestConfig config = RequestConfig.custom().setSocketTimeout(3000).setConnectTimeout(100).setConnectionRequestTimeout(100).build();
                httpClient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
                StringBuilder url = new StringBuilder();
                String frUrlKanbanUrl = this.getKanbanUrl(reportApi);
                url.append(frUrlKanbanUrl).append("?").append("infoType").append("=").append(URLEncoder.encode("lang", "UTF-8")).append("&language").append("=").append(URLEncoder.encode(language, "UTF-8")).append("&appId").append("=").append(URLEncoder.encode(product, "UTF-8"));
                HttpGet getMethod = new HttpGet(url.toString());
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
                     InputStream responseStream = response.getEntity().getContent();){
                    if (responseStream != null) {
                        String responseBody = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                        responseObject = (Map)gson.fromJson(responseBody, Map.class);
                    }
                }
            }
            if (responseObject == null) continue;
            List objs = (List)responseObject.get("Kanban_Info");
            for (Map obj : objs) {
                HashMap info = new HashMap();
                info.put("code", obj.get("id"));
                info.put("module", obj.get("module"));
                Map lang = (Map)obj.get("language");
                info.put("name", lang.get(language));
                res.add(info);
            }
        }
        return DWServiceResultBuilder.build(res);
    }

    public Object get(String code) throws Exception {
        String product = DWApplicationConfigUtils.getProperty((String)"appId");
        return this.get(code, product);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String code, String product) throws Exception {
        String[] reportApiArray;
        String reportApiUrl = DWApplicationConfigUtils.getProperty((String)"frUrl");
        HashMap<String, Object> res = null;
        if (reportApiUrl == null || reportApiUrl.isEmpty()) {
            return res;
        }
        for (String reportApi : reportApiArray = reportApiUrl.split(",")) {
            if (res != null) break;
            Gson gson = new GsonBuilder().create();
            Map responseObject = null;
            try (CloseableHttpClient httpClient = null;){
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
                connectionManager.setDefaultMaxPerRoute(1);
                connectionManager.setMaxTotal(1);
                RequestConfig config = RequestConfig.custom().setSocketTimeout(3000).setConnectTimeout(100).setConnectionRequestTimeout(100).build();
                httpClient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
                StringBuilder url = new StringBuilder();
                String frUrlKanbanUrl = this.getKanbanUrl(reportApi);
                url.append(frUrlKanbanUrl).append("?").append("id").append("=").append(URLEncoder.encode(code, "UTF-8")).append("&appId").append("=").append(URLEncoder.encode(product, "UTF-8"));
                HttpGet getMethod = new HttpGet(url.toString());
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
                     InputStream responseStream = response.getEntity().getContent();){
                    if (responseStream != null) {
                        String responseBody = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                        responseObject = (Map)gson.fromJson(responseBody, Map.class);
                    }
                }
            }
            if (responseObject == null) continue;
            List objs = (List)responseObject.get("Kanban_Info");
            for (Map obj : objs) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("code", obj.get("id"));
                info.put("fixparam", this.GetParameter(obj, "fixparam"));
                info.put("from", obj.get("from"));
                ArrayList lstLang = new ArrayList();
                Map lang = (Map)obj.get("language");
                if (lang != null) {
                    for (Map.Entry entry : lang.entrySet()) {
                        HashMap<String, Object> language = new HashMap<String, Object>();
                        language.put("language", entry.getKey());
                        language.put("name", entry.getValue());
                        lstLang.add(language);
                    }
                }
                info.put("languages", lstLang);
                info.put("module", obj.get("module"));
                info.put("name", obj.get("name"));
                info.put("parameter", this.GetParameter(obj, "parameter"));
                info.put("type", obj.get("type"));
                res = info;
            }
        }
        return DWServiceResultBuilder.build(res);
    }

    private Object GetParameter(Map<String, Object> obj, String name) {
        ArrayList lstP = new ArrayList();
        List lstPara = (List)obj.get(name);
        if (lstPara != null) {
            for (Map p : lstPara) {
                for (Map.Entry entry : p.entrySet()) {
                    HashMap<String, Object> para = new HashMap<String, Object>();
                    para.put("name", entry.getKey());
                    para.put("value", entry.getValue());
                    lstP.add(para);
                }
            }
        }
        return lstP;
    }

    private String getKanbanUrl(String reportApi) {
        String frUrlKanbanUrl = reportApi + frUrlKanbanUrlInfo;
        return frUrlKanbanUrl;
    }
}

