/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryElement;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryJoinOperator;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.log.utils.DWLogAppenderUtil;
import com.digiwin.app.log.utils.DWLogUtils;
import com.digiwin.dwapi.dwsys.service.ILogService;
import com.digiwin.utils.DWTenantUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.bson.conversions.Bson;

public class LogService
implements ILogService {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String KEY_TENANTSID = DWTenantUtils.getTenantColumnName();
    private Log logLogger = LogFactory.getLog((String)"com.digiwin.dwsys.service.impl.LogLogger");
    private Log traceLogger = LogFactory.getLog((String)"com.digiwin.dwsys.service.impl.TraceLogger");
    private MongoClient logsMongoClient;
    private MongoDatabase logsMongoDatabase;
    private MongoCollection<BasicDBObject> logsCollection;
    private MongoClient tracesMongoClient;
    private MongoDatabase tracesMongoDatabase;
    private MongoCollection<BasicDBObject> tracesCollection;

    public Object post(String time, String level, String loggerName, String app, String source, Map<String, Object> message) throws Exception {
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        if (time == null || time.isEmpty()) {
            Date now = new Date();
            logMap.putIfAbsent("time", this.sdf.format(now));
            logMap.putIfAbsent("time2", now);
        } else {
            logMap.putIfAbsent("time", time);
            logMap.putIfAbsent("time2", this.sdf.parse(time));
        }
        logMap.putIfAbsent("loggerName", loggerName);
        logMap.putIfAbsent("appId", app);
        logMap.putIfAbsent("source", source);
        logMap.putIfAbsent("message", message);
        DWLogUtils.writeLogLog((String)level, logMap);
        return DWServiceResultBuilder.build((boolean)true, null);
    }

    public Object get(DWPagableQueryInfo queryInfo) throws Exception {
        boolean hasNext;
        this.logsCollection = this.getLogsCollection();
        ArrayList<Map> result = new ArrayList<Map>();
        int pageSize = queryInfo.getPageSize();
        int pageNumber = queryInfo.getPageNumber();
        FindIterable findResult = this.logsCollection.find(this.Condition2Bson(queryInfo.getCondition())).projection(Projections.exclude((String[])new String[]{"time2", "_id"})).limit(pageSize + 1).skip((pageNumber - 1) * pageSize).sort(this.Order2Bson(queryInfo.getOrderfields()));
        for (BasicDBObject obj : findResult) {
            result.add(obj.toMap());
        }
        boolean bl = hasNext = result.size() == pageSize + 1;
        if (hasNext) {
            result.remove(pageSize);
        }
        HashMap<String, Serializable> resultObj = new HashMap<String, Serializable>();
        resultObj.putIfAbsent("logs", result);
        resultObj.putIfAbsent("hasNext", Boolean.valueOf(hasNext));
        return DWServiceResultBuilder.build((boolean)true, resultObj);
    }

    public Object getCount(DWQueryCondition condition) throws Exception {
        this.logsCollection = this.getLogsCollection();
        long resultCount = this.logsCollection.countDocuments(this.Condition2Bson(condition));
        return DWServiceResultBuilder.build((boolean)true, (Object)resultCount);
    }

    public Object delete(DWQueryCondition condition) throws Exception {
        this.logsCollection = this.getLogsCollection();
        DeleteResult deleteResult = this.logsCollection.deleteMany(this.Condition2Bson(condition));
        return DWServiceResultBuilder.build((boolean)true, (Object)deleteResult.getDeletedCount());
    }

    public Object postTrace(String time, String level, String loggerName, String app, String source, String tracerId, Map<String, Object> message) throws Exception {
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        if (time == null || time.isEmpty()) {
            Date now = new Date();
            logMap.putIfAbsent("time", this.sdf.format(now));
            logMap.putIfAbsent("time2", now);
        } else {
            logMap.putIfAbsent("time", time);
            logMap.putIfAbsent("time2", this.sdf.parse(time));
        }
        logMap.putIfAbsent("loggerName", loggerName);
        logMap.putIfAbsent("app", app);
        logMap.putIfAbsent("source", source);
        logMap.putIfAbsent("tracerId", tracerId);
        logMap.putIfAbsent("message", message);
        DWLogUtils.writeTraceLog((String)level, logMap);
        return DWServiceResultBuilder.build((boolean)true, null);
    }

    public Object getTrace(DWPagableQueryInfo queryInfo) throws Exception {
        boolean hasNext;
        this.tracesCollection = this.getTracesCollection();
        ArrayList<Map> result = new ArrayList<Map>();
        int pageSize = queryInfo.getPageSize();
        int pageNumber = queryInfo.getPageNumber();
        FindIterable findResult = this.tracesCollection.find(this.Condition2Bson(queryInfo.getCondition())).projection(Projections.exclude((String[])new String[]{"time2", "_id"})).limit(pageSize + 1).skip((pageNumber - 1) * pageSize).sort(this.Order2Bson(queryInfo.getOrderfields()));
        for (BasicDBObject obj : findResult) {
            result.add(obj.toMap());
        }
        boolean bl = hasNext = result.size() == pageSize + 1;
        if (hasNext) {
            result.remove(pageSize);
        }
        HashMap<String, Serializable> resultObj = new HashMap<String, Serializable>();
        resultObj.putIfAbsent("logs", result);
        resultObj.putIfAbsent("hasNext", Boolean.valueOf(hasNext));
        return DWServiceResultBuilder.build((boolean)true, resultObj);
    }

    public Object getTraceCount(DWQueryCondition condition) throws Exception {
        this.tracesCollection = this.getTracesCollection();
        long resultCount = this.tracesCollection.countDocuments(this.Condition2Bson(condition));
        return DWServiceResultBuilder.build((boolean)true, (Object)resultCount);
    }

    public Object deleteTrace(DWQueryCondition condition) throws Exception {
        this.tracesCollection = this.getTracesCollection();
        DeleteResult deleteResult = this.tracesCollection.deleteMany(this.Condition2Bson(condition));
        return DWServiceResultBuilder.build((boolean)true, (Object)deleteResult.getDeletedCount());
    }

    private MongoCollection<BasicDBObject> getLogsCollection() throws Exception {
        if (this.logsCollection == null) {
            this.logsCollection = DWLogAppenderUtil.getLogsCollection();
        }
        return this.logsCollection;
    }

    private MongoCollection<BasicDBObject> getTracesCollection() throws Exception {
        if (this.tracesCollection == null) {
            this.tracesCollection = DWLogAppenderUtil.getTracesCollection();
        }
        return this.tracesCollection;
    }

    private Bson Element2Bson(DWQueryElement element) {
        if (element instanceof DWQueryCondition) {
            return this.Condition2Bson((DWQueryCondition)element);
        }
        if (element instanceof DWQueryField) {
            return this.Field2Bson((DWQueryField)element);
        }
        throw new IllegalArgumentException(element.getClass().toString());
    }

    private Bson Field2Bson(DWQueryField field) {
        Object[] values = field.getValues();
        Object firstValue = field.getFirstValue();
        String fieldName = field.getName();
        DWQueryValueOperator operator = field.getOperator();
        if (operator == null) {
            operator = DWQueryValueOperator.Equals;
        }
        switch (operator) {
            case BETWEEN: 
            case Between: {
                return Filters.and((Bson[])new Bson[]{Filters.gte((String)fieldName, (Object)values[0]), Filters.lte((String)fieldName, (Object)values[1])});
            }
            case EQUAL: 
            case Equals: {
                return Filters.eq((String)fieldName, (Object)firstValue);
            }
            case GreaterThan: {
                return Filters.gt((String)fieldName, (Object)firstValue);
            }
            case GreaterThanOrEqualTo: {
                return Filters.gte((String)fieldName, (Object)firstValue);
            }
            case IN: 
            case In: {
                return Filters.in((String)fieldName, (Object[])values);
            }
            case NOTIN: 
            case NotIn: {
                return Filters.nin((String)fieldName, (Object[])values);
            }
            case LessThan: {
                return Filters.lt((String)fieldName, (Object)firstValue);
            }
            case LessThanOrEqualTo: {
                return Filters.lte((String)fieldName, (Object)firstValue);
            }
            case NotEquals: {
                return Filters.ne((String)fieldName, (Object)firstValue);
            }
            case LIKE: 
            case Like: {
                Pattern queryPattern = Pattern.compile(firstValue.toString(), 2);
                return Filters.eq((String)fieldName, (Object)queryPattern);
            }
        }
        throw new IllegalArgumentException(operator.toString());
    }

    private Bson Condition2Bson(DWQueryCondition condition) {
        DWQueryJoinOperator joinOperator = condition.getJoinOperator();
        List<Bson> subConditions = this.Element2Bsons(condition.getItems());
        if (subConditions.size() == 0) {
            return new BasicDBObject();
        }
        if (joinOperator == DWQueryJoinOperator.AND) {
            return Filters.and(this.Element2Bsons(condition.getItems()));
        }
        return Filters.or(this.Element2Bsons(condition.getItems()));
    }

    private List<Bson> Element2Bsons(List<DWQueryElement> conditions) {
        ArrayList<Bson> result = new ArrayList<Bson>();
        for (DWQueryElement element : conditions) {
            Bson bson = this.Element2Bson(element);
            result.add(bson);
        }
        return result;
    }

    private Bson Order2Bson(List<DWQueryOrderby> orderfields) {
        ArrayList<Bson> orderBsons = new ArrayList<Bson>();
        block6: for (DWQueryOrderby orderBy : orderfields) {
            switch (orderBy.getOrderby().toUpperCase()) {
                case "DESC": {
                    orderBsons.add(Sorts.descending((String[])new String[]{orderBy.getName()}));
                    continue block6;
                }
            }
            orderBsons.add(Sorts.ascending((String[])new String[]{orderBy.getName()}));
        }
        return Sorts.orderBy(orderBsons);
    }

    public Object post(Object params) throws Exception {
        if (params == null) {
            return new DWArgumentException("LogService", "params is null");
        }
        Map inputMap = (Map)params;
        String appInput = (String)inputMap.get("appId");
        List logDatas = (List)inputMap.get("logDatas");
        if (logDatas != null && logDatas.size() > 0) {
            ThreadContext.put((String)"logType", (String)"freezen");
            for (Map logRow : logDatas) {
                logRow.put("appId", appInput);
                if (logRow.containsKey(this.KEY_TENANTSID)) {
                    Long tenantsid = ((Double)logRow.get(this.KEY_TENANTSID)).longValue();
                    logRow.put(this.KEY_TENANTSID, tenantsid);
                }
                String level = logRow.getOrDefault("level", Level.INFO.toString());
                DWLogUtils.writeLogLog((String)level, (Map)logRow);
            }
        }
        return DWServiceResultBuilder.build((boolean)true, (Object)"successful");
    }
}

