/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.sql.DBUtils;
import com.digiwin.dwapi.dwsys.service.ICustomColumnService;
import com.digiwin.utils.DWTenantUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CustomColumnService
implements ICustomColumnService {
    private static final String KEY_TABLE_ID = "tableId";
    private static final String KEY_USER_ID = "userId";
    private static final String KEY_CONFIG = "config";
    private static final String KEY_DEFAULT_CONFIG = "default_config";
    private static final String KEY_USER_CONFIG = "user_config";
    private static final String DB_KEY_TABLE_ID = "table_id";
    private static final String DB_KEY_USER_ID = "userid";
    private static final String DB_KEY_CONFIG = "config";
    private static final String TABLE_CUSTOM_COLUMN = "dw_custom_column";
    private static final String STATEMENT_INSERT_CUSTOM_COLUMN = "INSERT INTO dw_custom_column (table_id,config,userid" + DWTenantUtils.getSqlTenantNameTag() + ") VALUES (?, ?, ?" + DWTenantUtils.getSqlTenantValueTag() + ") ON DUPLICATE KEY UPDATE config=?";
    static final String INSERT_STATEMENT = "INSERT INTO dw_custom_column ( config, table_id, userid " + DWTenantUtils.getSqlTenantNameTag() + ")  VALUES (?, ?, ?" + DWTenantUtils.getSqlTenantValueTag() + ") ";
    static final String UPDATE_STATEMENT = "UPDATE dw_custom_column SET config = ? WHERE 1=1 AND table_id=? AND userid=? " + DWTenantUtils.getTenantTagByColumnName();
    private static final String STATEMENT_SELECT_CUSTOM_COLUMN = "select * from dw_custom_column where 1=1 and table_id=? and userid=? " + DWTenantUtils.getTenantTagByColumnName();
    private static final String STATEMENT_SELECT_CUSTOM_COLUMN_FOR_DM8 = "select tenantsid, table_id, userid, cast(config as varchar) as config from dw_custom_column where 1=1 and table_id=? and userid=? " + DWTenantUtils.getTenantTagByColumnName();
    private static final String MESSAGE_SUCCESS = "success";
    @Autowired(required=false)
    @Qualifier(value="dw-dao")
    private DWDao dao;

    public Object post(Map<String, Object> param) throws Exception {
        String loginUserId = MapUtils.getString((Map)DWServiceContext.getContext().getProfile(), (Object)KEY_USER_ID, (String)"");
        String userId = MapUtils.getString(param, (Object)KEY_USER_ID, (String)loginUserId);
        param.put(KEY_USER_ID, userId);
        Object resultData = this.updateConfigCore(param);
        return DWServiceResultBuilder.build((boolean)true, (String)MESSAGE_SUCCESS, (Object)resultData);
    }

    public Object get(String userId, String tableId) throws Exception {
        Map<String, Object> result = this.selectConfigCore(tableId, userId);
        return DWServiceResultBuilder.build((boolean)true, (String)MESSAGE_SUCCESS, result);
    }

    public Object get(String tableId) throws Exception {
        String userId = MapUtils.getString((Map)DWServiceContext.getContext().getProfile(), (Object)KEY_USER_ID, (String)"");
        Map<String, Object> result = this.selectConfigCore(tableId, userId);
        return DWServiceResultBuilder.build((boolean)true, (String)MESSAGE_SUCCESS, result);
    }

    public Object delete(String userId, String tableId) throws Exception {
        DWDataSet dataSet = new DWDataSet();
        dataSet.newTable(TABLE_CUSTOM_COLUMN).newRow().setState("D").set(DB_KEY_TABLE_ID, (Object)tableId).set(DB_KEY_USER_ID, (Object)userId);
        return DWServiceResultBuilder.build((boolean)true, (String)MESSAGE_SUCCESS, (Object)this.dao.execute(dataSet));
    }

    public Object delete(String tableId) throws Exception {
        String userId = MapUtils.getString((Map)DWServiceContext.getContext().getProfile(), (Object)KEY_USER_ID, (String)"");
        DWDataSet dataSet = new DWDataSet();
        dataSet.newTable(TABLE_CUSTOM_COLUMN).newRow().setState("D").set(DB_KEY_TABLE_ID, (Object)tableId).set(DB_KEY_USER_ID, (Object)userId);
        return DWServiceResultBuilder.build((boolean)true, (String)MESSAGE_SUCCESS, (Object)this.dao.execute(dataSet));
    }

    public Object postDefault(Map<String, Object> param) throws Exception {
        param.put(KEY_USER_ID, "");
        Object resultData = this.updateConfigCore(param);
        return DWServiceResultBuilder.build((boolean)true, (String)MESSAGE_SUCCESS, (Object)resultData);
    }

    public Object deleteDefault(String tableId) throws Exception {
        DWDataSet dataSet = new DWDataSet();
        dataSet.newTable(TABLE_CUSTOM_COLUMN).newRow().setState("D").set(DB_KEY_TABLE_ID, (Object)tableId).set(DB_KEY_USER_ID, (Object)"");
        return DWServiceResultBuilder.build((boolean)true, (String)MESSAGE_SUCCESS, (Object)this.dao.execute(dataSet));
    }

    private Object updateConfigCore(Map<String, Object> param) {
        List userConfigList;
        String tableId = MapUtils.getString(param, (Object)KEY_TABLE_ID);
        String userId = MapUtils.getString(param, (Object)KEY_USER_ID);
        DWGsonProvider.getGson().serializeNulls();
        String config = DWGsonProvider.getGson().toJson((Object)MapUtils.getMap(param, (Object)"config"));
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        String querySql = STATEMENT_SELECT_CUSTOM_COLUMN;
        String updateSql = INSERT_STATEMENT;
        if (DBUtils.isDM8()) {
            querySql = STATEMENT_SELECT_CUSTOM_COLUMN_FOR_DM8;
        }
        if (Objects.nonNull(userConfigList = this.dao.select(querySql, new Object[]{tableId, userId})) && !userConfigList.isEmpty()) {
            updateSql = UPDATE_STATEMENT;
        }
        return this.dao.update((IDWSQLOptions)option, updateSql, new Object[]{config, tableId, userId});
    }

    private Map<String, Object> selectConfigCore(String tableId, String userId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String querySql = STATEMENT_SELECT_CUSTOM_COLUMN;
        if (DBUtils.isDM8()) {
            querySql = STATEMENT_SELECT_CUSTOM_COLUMN_FOR_DM8;
        }
        List userConfigList = this.dao.select(querySql, new Object[]{tableId, userId});
        List defaultConfigList = this.dao.select(querySql, new Object[]{tableId, ""});
        Map<String, Object> userConfigMap = this.toConfigJson(userConfigList);
        Map<String, Object> defaultConfigMap = this.toConfigJson(defaultConfigList);
        result.put(KEY_USER_CONFIG, userConfigMap);
        result.put(KEY_DEFAULT_CONFIG, defaultConfigMap);
        return result;
    }

    private Map<String, Object> toConfigJson(List<Map<String, Object>> src) throws Exception {
        Map<String, Object> result = new HashMap<String, Object>();
        if (src == null) {
            return result;
        }
        if (!src.isEmpty()) {
            result = src.get(0);
            String config = MapUtils.getString(result, (Object)"config");
            try {
                Map configMap = (Map)DWGsonProvider.getGson().fromJson(config, Map.class);
                result.put("config", configMap);
            }
            catch (Exception e) {
                throw new DWException("The json format of config isn't illegal or isn't an object", (Throwable)e);
            }
        }
        return result;
    }
}

