/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.service.AllowCrossTenant;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.dwapi.dwsys.service.IServiceInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ServiceInfoService
implements IServiceInfoService {
    @Autowired
    @Qualifier(value="DWHeaderRepository")
    private DWHeaderRepository headerRepository;

    public DWServiceResult getCrossTenant() throws Exception {
        List headers = this.headerRepository.getAllHeader();
        ArrayList serviceInfos = new ArrayList();
        for (DWHeader header : headers) {
            String moduleName = header.getModuleName();
            String serviceName = header.getServiceName();
            Map methods = header.getDWMethods();
            block1: for (Map.Entry methodEntry : methods.entrySet()) {
                List dwMethods = (List)methodEntry.getValue();
                String methodName = (String)methodEntry.getKey();
                for (DWMethod dwMethod : dwMethods) {
                    if (!dwMethod.allowCrossTenant()) continue;
                    AllowCrossTenant annotationAllowCrossTenant = dwMethod.getMethod().getAnnotation(AllowCrossTenant.class);
                    String crossTenantServiceName = annotationAllowCrossTenant.name();
                    HashMap<String, Object> serviceInfo = new HashMap<String, Object>();
                    serviceInfo.put("api", "restful/service/" + moduleName + "/" + serviceName + "/" + methodName);
                    serviceInfo.put("serviceName", crossTenantServiceName);
                    serviceInfos.add(serviceInfo);
                    continue block1;
                }
            }
        }
        DWServiceResult result = new DWServiceResult(serviceInfos);
        return result;
    }
}

