/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.PropertiesUtil;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.digiwin.apollo.application.exceptions.ApolloConfigException;
import com.digiwin.apollo.application.internals.AbstractConfigFile;
import com.digiwin.apollo.application.internals.ConfigRepository;
import com.digiwin.apollo.application.util.ExceptionUtil;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public class PropertiesConfigFile
extends AbstractConfigFile {
    protected AtomicReference<String> m_contentCache = new AtomicReference();

    public PropertiesConfigFile(String namespace, ConfigRepository configRepository) {
        super(namespace, configRepository);
    }

    @Override
    protected void update(Properties newProperties) {
        this.m_configProperties.set(newProperties);
        this.m_contentCache.set(null);
    }

    @Override
    public String getContent() {
        if (this.m_contentCache.get() == null) {
            this.m_contentCache.set(this.doGetContent());
        }
        return this.m_contentCache.get();
    }

    String doGetContent() {
        if (!this.hasContent()) {
            return null;
        }
        try {
            return PropertiesUtil.toString((Properties)this.m_configProperties.get());
        }
        catch (Throwable ex) {
            ApolloConfigException exception = new ApolloConfigException(String.format("Parse properties file content failed for namespace: %s, cause: %s", this.m_namespace, ExceptionUtil.getDetailMessage(ex)));
            Tracer.logError(exception);
            throw exception;
        }
    }

    @Override
    public boolean hasContent() {
        return this.m_configProperties.get() != null && !((Properties)this.m_configProperties.get()).isEmpty();
    }

    @Override
    public ConfigFileFormat getConfigFileFormat() {
        return ConfigFileFormat.Properties;
    }
}

