/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.group.spi;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.group.GroupConfig;
import com.digiwin.apollo.group.GroupConfigFile;
import com.digiwin.apollo.group.GroupConfigService;
import com.digiwin.apollo.group.PropertiesCompatibleConfigFile;
import com.digiwin.apollo.group.build.ApolloInjector;
import com.digiwin.apollo.group.internals.DefaultConfig;
import com.digiwin.apollo.group.internals.JsonConfigFile;
import com.digiwin.apollo.group.internals.LocalFileConfigRepository;
import com.digiwin.apollo.group.internals.PropertiesCompatibleFileConfigRepository;
import com.digiwin.apollo.group.internals.PropertiesConfigFile;
import com.digiwin.apollo.group.internals.RemoteConfigRepository;
import com.digiwin.apollo.group.internals.TxtConfigFile;
import com.digiwin.apollo.group.internals.XmlConfigFile;
import com.digiwin.apollo.group.internals.YamlConfigFile;
import com.digiwin.apollo.group.internals.YmlConfigFile;
import com.digiwin.apollo.group.spi.ConfigFactory;
import com.digiwin.apollo.group.util.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfigFactory
implements ConfigFactory {
    private static final Log logger = LogFactory.getLog(DefaultConfigFactory.class);
    private ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);

    @Override
    public GroupConfig create(String namespace) {
        ConfigFileFormat format = this.determineFileFormat(namespace);
        if (ConfigFileFormat.isPropertiesCompatible(format)) {
            return new DefaultConfig(namespace, this.createPropertiesCompatibleFileConfigRepository(namespace, format));
        }
        return new DefaultConfig(namespace, this.createLocalConfigRepository(namespace));
    }

    @Override
    public GroupConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        LocalFileConfigRepository configRepository = this.createLocalConfigRepository(namespace);
        switch (configFileFormat) {
            case Properties: {
                return new PropertiesConfigFile(namespace, configRepository);
            }
            case XML: {
                return new XmlConfigFile(namespace, configRepository);
            }
            case JSON: {
                return new JsonConfigFile(namespace, configRepository);
            }
            case YAML: {
                return new YamlConfigFile(namespace, configRepository);
            }
            case YML: {
                return new YmlConfigFile(namespace, configRepository);
            }
            case TXT: {
                return new TxtConfigFile(namespace, configRepository);
            }
        }
        return null;
    }

    LocalFileConfigRepository createLocalConfigRepository(String namespace) {
        if (this.m_configUtil.isInLocalMode()) {
            logger.warn((Object)("==== Apollo is in local mode! Won't pull configs from remote server for namespace " + namespace + " ! ===="));
            return new LocalFileConfigRepository(namespace);
        }
        return new LocalFileConfigRepository(namespace, this.createRemoteConfigRepository(namespace));
    }

    RemoteConfigRepository createRemoteConfigRepository(String namespace) {
        return new RemoteConfigRepository(namespace);
    }

    PropertiesCompatibleFileConfigRepository createPropertiesCompatibleFileConfigRepository(String namespace, ConfigFileFormat format) {
        String actualNamespaceName = this.trimNamespaceFormat(namespace, format);
        PropertiesCompatibleConfigFile configFile = (PropertiesCompatibleConfigFile)GroupConfigService.getConfigFile(actualNamespaceName, format);
        return new PropertiesCompatibleFileConfigRepository(configFile);
    }

    ConfigFileFormat determineFileFormat(String namespaceName) {
        String lowerCase = namespaceName.toLowerCase();
        for (ConfigFileFormat format : ConfigFileFormat.values()) {
            if (!lowerCase.endsWith("." + format.getValue())) continue;
            return format;
        }
        return ConfigFileFormat.Properties;
    }

    String trimNamespaceFormat(String namespaceName, ConfigFileFormat format) {
        String extension = "." + format.getValue();
        if (!namespaceName.toLowerCase().endsWith(extension)) {
            return namespaceName;
        }
        return namespaceName.substring(0, namespaceName.length() - extension.length());
    }
}

