/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigRegistry;

public class ConfigService {
    private static final ConfigService s_instance = new ConfigService();
    private volatile ConfigManager m_configManager;
    private volatile ConfigRegistry m_configRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigManager getManager() {
        if (this.m_configManager == null) {
            ConfigService configService = this;
            synchronized (configService) {
                if (this.m_configManager == null) {
                    this.m_configManager = ApolloInjector.getInstance(ConfigManager.class);
                }
            }
        }
        return this.m_configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRegistry getRegistry() {
        if (this.m_configRegistry == null) {
            ConfigService configService = this;
            synchronized (configService) {
                if (this.m_configRegistry == null) {
                    this.m_configRegistry = ApolloInjector.getInstance(ConfigRegistry.class);
                }
            }
        }
        return this.m_configRegistry;
    }

    public static Config getAppConfig() {
        return ConfigService.getConfig("application");
    }

    public static Config getConfig(String namespace) {
        return s_instance.getManager().getConfig(namespace);
    }

    public static ConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return s_instance.getManager().getConfigFile(namespace, configFileFormat);
    }

    static void setConfig(Config config) {
        ConfigService.setConfig("application", config);
    }

    static void setConfig(String namespace, final Config config) {
        s_instance.getRegistry().register(namespace, new ConfigFactory(){

            @Override
            public Config create(String namespace) {
                return config;
            }

            @Override
            public ConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }
        });
    }

    static void setConfigFactory(ConfigFactory factory) {
        ConfigService.setConfigFactory("application", factory);
    }

    static void setConfigFactory(String namespace, ConfigFactory factory) {
        s_instance.getRegistry().register(namespace, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        ConfigService configService = s_instance;
        synchronized (configService) {
            ConfigService.s_instance.m_configManager = null;
            ConfigService.s_instance.m_configRegistry = null;
        }
    }
}

