/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.internals;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.application.ApplicationConfig;
import com.digiwin.apollo.application.ApplicationConfigFile;
import com.digiwin.apollo.application.build.ApolloInjector;
import com.digiwin.apollo.application.internals.ConfigManager;
import com.digiwin.apollo.application.spi.ConfigFactory;
import com.digiwin.apollo.application.spi.ConfigFactoryManager;
import com.google.common.collect.Maps;
import java.util.Map;

public class DefaultConfigManager
implements ConfigManager {
    private ConfigFactoryManager m_factoryManager;
    private Map<String, ApplicationConfig> m_configs = Maps.newConcurrentMap();
    private Map<String, ApplicationConfigFile> m_configFiles = Maps.newConcurrentMap();

    public DefaultConfigManager() {
        this.m_factoryManager = ApolloInjector.getInstance(ConfigFactoryManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationConfig getConfig(String namespace) {
        ApplicationConfig config = this.m_configs.get(namespace);
        if (config == null) {
            DefaultConfigManager defaultConfigManager = this;
            synchronized (defaultConfigManager) {
                config = this.m_configs.get(namespace);
                if (config == null) {
                    ConfigFactory factory = this.m_factoryManager.getFactory(namespace);
                    config = factory.create(namespace);
                    this.m_configs.put(namespace, config);
                }
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        String namespaceFileName = String.format("%s.%s", namespace, configFileFormat.getValue());
        ApplicationConfigFile configFile = this.m_configFiles.get(namespaceFileName);
        if (configFile == null) {
            DefaultConfigManager defaultConfigManager = this;
            synchronized (defaultConfigManager) {
                configFile = this.m_configFiles.get(namespaceFileName);
                if (configFile == null) {
                    ConfigFactory factory = this.m_factoryManager.getFactory(namespaceFileName);
                    configFile = factory.createConfigFile(namespaceFileName, configFileFormat);
                    this.m_configFiles.put(namespaceFileName, configFile);
                }
            }
        }
        return configFile;
    }
}

